/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.service;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.qubership.integration.platform.engine.configuration.ServerConfiguration;
import org.qubership.integration.platform.engine.model.deployment.engine.EngineDeploymentsDTO;
import org.qubership.integration.platform.engine.model.deployment.update.DeploymentsUpdate;
import org.qubership.integration.platform.engine.service.IntegrationRuntimeService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class DeploymentsUpdateService {
    private static final Logger log = LoggerFactory.getLogger(DeploymentsUpdateService.class);
    public static final String DEPLOYMENTS_UPDATE_PATH = "/v1/catalog/domains/{domain}/deployments/update";
    private final IntegrationRuntimeService integrationRuntimeService;
    private final ServerConfiguration serverConfiguration;
    private final RestTemplate restTemplate;
    @Value(value="${qip.internal-services.runtime-catalog.url}")
    private String runtimeCatalogUrl;

    @Autowired
    public DeploymentsUpdateService(IntegrationRuntimeService integrationRuntimeService, ServerConfiguration serverConfiguration, @Qualifier(value="restTemplateMS") RestTemplate restTemplate) {
        this.integrationRuntimeService = integrationRuntimeService;
        this.serverConfiguration = serverConfiguration;
        this.restTemplate = restTemplate;
    }

    public void getAndProcess() throws ExecutionException, InterruptedException {
        List excludeDeploymentsMap = this.integrationRuntimeService.buildExcludeDeploymentsMap();
        EngineDeploymentsDTO excluded = EngineDeploymentsDTO.builder().excludeDeployments(excludeDeploymentsMap).build();
        DeploymentsUpdate update = this.getDeploymentsUpdate(excluded);
        log.info("Processing of new deployments has started");
        this.integrationRuntimeService.processAndUpdateState(update, false);
        log.info("Processing of new deployments completed");
    }

    private DeploymentsUpdate getDeploymentsUpdate(EngineDeploymentsDTO excluded) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        ResponseEntity response = this.restTemplate.exchange(this.runtimeCatalogUrl + DEPLOYMENTS_UPDATE_PATH, HttpMethod.POST, new HttpEntity((Object)excluded, (MultiValueMap)headers), DeploymentsUpdate.class, Map.of("domain", this.serverConfiguration.getDomain()));
        if (response.getStatusCode() != HttpStatus.OK) {
            log.error("Failed to get deployments update from runtime catalog, code: {}, body: {}", (Object)response.getStatusCode(), response.getBody());
            throw new RuntimeException("Failed to get deployments update from runtime catalog, response with non 2xx code");
        }
        return (DeploymentsUpdate)response.getBody();
    }
}

