/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.camel.components.directvm;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.camel.AsyncCallback;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePropertyKey;
import org.apache.camel.Processor;
import org.apache.camel.support.DefaultExchange;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.support.processor.DelegateAsyncProcessor;
import org.qubership.integration.platform.engine.camel.components.directvm.ChainEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ChainProcessor
extends DelegateAsyncProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(ChainProcessor.class);
    private final ChainEndpoint endpoint;

    public ChainProcessor(Processor processor, ChainEndpoint endpoint) {
        super(processor);
        this.endpoint = endpoint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean process(final Exchange exchange, final AsyncCallback callback) {
        final Exchange copy = this.prepareExchange(exchange);
        final ClassLoader current = Thread.currentThread().getContextClassLoader();
        boolean changed = false;
        try {
            ClassLoader appClassLoader = this.endpoint.getCamelContext().getApplicationContextClassLoader();
            if (appClassLoader != null) {
                LOG.trace("Setting Thread ContextClassLoader to {}", (Object)appClassLoader);
                Thread.currentThread().setContextClassLoader(appClassLoader);
                changed = true;
            }
            final boolean chgd = changed;
            boolean bl = this.processor.process(copy, new AsyncCallback(){

                public void done(boolean done) {
                    try {
                        if (chgd) {
                            LOG.trace("Restoring Thread ContextClassLoader to {}", (Object)current);
                            Thread.currentThread().setContextClassLoader(current);
                        }
                        ExchangeHelper.copyResults((Exchange)exchange, (Exchange)copy);
                    }
                    finally {
                        callback.done(done);
                    }
                }
            });
            return bl;
        }
        finally {
            if (changed) {
                LOG.trace("Restoring Thread ContextClassLoader to {}", (Object)current);
                Thread.currentThread().setContextClassLoader(current);
            }
        }
    }

    private Exchange prepareExchange(Exchange exchange) {
        Exchange newExchange = ChainProcessor.copyExchangeAndSetCamelContext(exchange, this.endpoint.getCamelContext(), false);
        newExchange.getExchangeExtension().setFromEndpoint((Endpoint)this.endpoint);
        if (newExchange.getProperty(ExchangePropertyKey.STREAM_CACHE_UNIT_OF_WORK) == null) {
            newExchange.setProperty(ExchangePropertyKey.STREAM_CACHE_UNIT_OF_WORK, (Object)exchange.getUnitOfWork());
        }
        return newExchange;
    }

    private static Exchange copyExchangeAndSetCamelContext(Exchange exchange, CamelContext context, boolean handover) {
        DefaultExchange answer = new DefaultExchange(context, exchange.getPattern());
        if (exchange.hasProperties()) {
            answer.getExchangeExtension().setProperties(ChainProcessor.safeCopyProperties(exchange.getProperties()));
        }
        exchange.getExchangeExtension().copyInternalProperties((Exchange)answer);
        List history = (List)exchange.getProperty(ExchangePropertyKey.MESSAGE_HISTORY);
        if (history != null) {
            answer.setProperty(ExchangePropertyKey.MESSAGE_HISTORY, new CopyOnWriteArrayList(history));
        }
        if (handover) {
            exchange.getExchangeExtension().handoverCompletions((Exchange)answer);
        }
        answer.setIn(exchange.getIn().copy());
        if (exchange.hasOut()) {
            answer.setOut(exchange.getOut().copy());
        }
        answer.setException((Throwable)exchange.getException());
        return answer;
    }

    private static Map<String, Object> safeCopyProperties(Map<String, Object> properties) {
        if (properties == null) {
            return null;
        }
        return new ConcurrentHashMap<String, Object>(properties);
    }

    public String toString() {
        return "ChainProcessor[" + String.valueOf(this.processor) + "]";
    }
}

