/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.camel.components.kafka;

import java.util.HashMap;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.SSLContextParametersAware;
import org.apache.camel.component.kafka.KafkaComponent;
import org.apache.camel.component.kafka.KafkaConfiguration;
import org.apache.camel.component.kafka.KafkaEndpoint;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.PropertyBindingSupport;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.PropertiesHelper;
import org.qubership.integration.platform.engine.camel.components.kafka.KafkaCustomEndpoint;

@Component(value="kafka-custom")
public class KafkaCustomComponent
extends KafkaComponent
implements SSLContextParametersAware {
    protected KafkaEndpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        if (ObjectHelper.isEmpty((String)remaining)) {
            throw new IllegalArgumentException("Topic must be configured on endpoint using syntax kafka:topic");
        }
        Map endpointAdditionalProperties = PropertiesHelper.extractProperties(parameters, (String)"additionalProperties.");
        KafkaCustomEndpoint endpoint = new KafkaCustomEndpoint(uri, this);
        KafkaConfiguration copy = this.getConfiguration().copy();
        endpoint.setConfiguration(copy);
        this.setProperties((Endpoint)endpoint, parameters);
        if (endpoint.getConfiguration().getSslContextParameters() == null) {
            endpoint.getConfiguration().setSslContextParameters(this.retrieveGlobalSslContextParameters());
        }
        if (!endpointAdditionalProperties.isEmpty()) {
            HashMap map = new HashMap();
            PropertyBindingSupport.bindProperties((CamelContext)this.getCamelContext(), map, (Map)endpointAdditionalProperties);
            endpoint.getConfiguration().getAdditionalProperties().putAll(map);
        }
        if (endpoint.getConfiguration().getTopic() == null) {
            endpoint.getConfiguration().setTopic(remaining);
        }
        return endpoint;
    }
}

