/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.camel.components.servlet;

import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.Map;
import org.apache.camel.http.common.HttpConsumer;
import org.apache.camel.http.common.HttpRestConsumerPath;
import org.apache.camel.http.common.HttpRestServletResolveConsumerStrategy;
import org.apache.camel.support.RestConsumerContextPathMatcher;
import org.qubership.integration.platform.engine.camel.components.servlet.RestConsumerContextPathCustomMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomHttpRestServletResolveConsumerStrategy
extends HttpRestServletResolveConsumerStrategy {
    private static final Logger log = LoggerFactory.getLogger(CustomHttpRestServletResolveConsumerStrategy.class);

    protected HttpConsumer doResolve(HttpServletRequest request, String method, Map<String, HttpConsumer> consumers) {
        String path = request.getPathInfo();
        if (path == null) {
            return null;
        }
        ArrayList<RestConsumerContextPathMatcher.ConsumerPath<HttpConsumer>> consumerPaths = new ArrayList<RestConsumerContextPathMatcher.ConsumerPath<HttpConsumer>>();
        for (Map.Entry<String, HttpConsumer> entry : consumers.entrySet()) {
            consumerPaths.add((RestConsumerContextPathMatcher.ConsumerPath<HttpConsumer>)new HttpRestConsumerPath(entry.getValue()));
        }
        RestConsumerContextPathMatcher.ConsumerPath<HttpConsumer> best = RestConsumerContextPathCustomMatcher.matchBestPath(method, path, consumerPaths);
        return best != null ? (HttpConsumer)best.getConsumer() : null;
    }
}

