/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.camel.components.servlet.binding;

import com.arakelian.json.ImmutableJsonFilterOptions;
import com.arakelian.json.JsonFilter;
import com.arakelian.json.JsonFilterOptions;
import com.arakelian.json.JsonReader;
import com.arakelian.json.JsonWriter;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.http.common.DefaultHttpBinding;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.commons.lang3.StringUtils;
import org.qubership.integration.platform.engine.camel.components.servlet.ServletCustomFilterStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class HandlingHttpBinding
extends DefaultHttpBinding {
    private static final Logger log = LoggerFactory.getLogger(HandlingHttpBinding.class);

    @Autowired
    public HandlingHttpBinding(ServletCustomFilterStrategy servletCustomFilterStrategy) {
        this.setHeaderFilterStrategy((HeaderFilterStrategy)servletCustomFilterStrategy);
    }

    public void writeResponse(Exchange exchange, HttpServletResponse response) throws IOException {
        Message target = exchange.getMessage();
        if (exchange.isFailed()) {
            if (exchange.getException() != null) {
                this.doWriteExceptionResponse(exchange.getException(), response, exchange);
            } else {
                this.doWriteFaultResponse(target, response, exchange);
            }
        } else {
            if (exchange.hasOut()) {
                this.copyProtocolHeaders(exchange.getIn(), exchange.getOut());
            }
            this.doWriteResponse(target, response, exchange);
        }
    }

    private void copyProtocolHeaders(Message request, Message response) {
        if (request.getHeader("Content-Encoding") != null) {
            String contentEncoding = (String)request.getHeader("Content-Encoding", String.class);
            response.setHeader("Content-Encoding", (Object)contentEncoding);
        }
        if (this.checkChunked(response, response.getExchange())) {
            response.setHeader("Transfer-Encoding", (Object)"chunked");
        }
    }

    public void doWriteExceptionResponse(Throwable exception, HttpServletResponse response) throws IOException {
        this.doWriteExceptionResponse(exception, response, null);
    }

    public void doWriteExceptionResponse(Throwable exception, HttpServletResponse response, Exchange exchange) throws IOException {
        if (exchange != null) {
            super.doWriteResponse(exchange.getMessage(), response, exchange);
            return;
        }
        this.sendInternalException(exception, response);
    }

    public void doWriteResponse(Message message, HttpServletResponse response, Exchange exchange) throws IOException {
        if (!exchange.isFailed()) {
            this.filterFieldsInResponse(message, exchange);
        }
        super.doWriteResponse(message, response, exchange);
    }

    private void sendInternalException(Throwable e, HttpServletResponse response) throws IOException {
        log.error("Unable to respond from chain http trigger due to exception", e);
        response.sendError(500);
    }

    private void filterFieldsInResponse(Message message, Exchange exchange) {
        String filterIncludeFields = (String)exchange.getProperty("internalProperty_responseFilterInclude", String.class);
        String filterExcludeFields = (String)exchange.getProperty("internalProperty_responseFilterExclude", String.class);
        ImmutableJsonFilterOptions.Builder filterOptionsBuilder = null;
        if (filterIncludeFields != null) {
            filterOptionsBuilder = this.getJsonFilterBuilder(filterOptionsBuilder).addAllIncludes(this.parseResponseFilterFields(filterIncludeFields));
        }
        if (filterExcludeFields != null) {
            filterOptionsBuilder = this.getJsonFilterBuilder(filterOptionsBuilder).addAllExcludes(this.parseResponseFilterFields(filterExcludeFields));
        }
        if (filterOptionsBuilder != null) {
            StringWriter sw;
            StringReader sr;
            try {
                String body = (String)message.getBody(String.class);
                message.setBody((Object)body);
                sr = new StringReader(body);
                sw = new StringWriter();
            }
            catch (Exception e) {
                log.warn("Unable to convert body for response filter", (Throwable)e);
                return;
            }
            JsonFilter filter = new JsonFilter(new JsonReader((Reader)sr), new JsonWriter((Writer)sw), (JsonFilterOptions)filterOptionsBuilder.build());
            try {
                filter.process();
                message.setBody((Object)sw.toString());
            }
            catch (IOException e) {
                log.warn("Failed to filter response", (Throwable)e);
                return;
            }
        }
    }

    private ImmutableJsonFilterOptions.Builder getJsonFilterBuilder(ImmutableJsonFilterOptions.Builder filterOptionsBuilder) {
        return filterOptionsBuilder == null ? ImmutableJsonFilterOptions.builder() : filterOptionsBuilder;
    }

    private List<String> parseResponseFilterFields(String filterFields) {
        return List.of(StringUtils.stripAll((String[])filterFields.replace('.', '/').split(",")));
    }
}

