/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.camel.processors;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.util.JsonFormat;
import java.util.List;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class GrpcSenderPostProcessor
implements Processor {
    private final JsonFormat.Printer grpcPrinter;
    private final ObjectMapper objectMapper;

    @Autowired
    public GrpcSenderPostProcessor(JsonFormat.Printer grpcPrinter, @Qualifier(value="jsonMapper") ObjectMapper objectMapper) {
        this.grpcPrinter = grpcPrinter;
        this.objectMapper = objectMapper;
    }

    public void process(Exchange exchange) throws Exception {
        exchange.getMessage().setBody((Object)this.extractBodyAsJsonString(exchange));
        exchange.getMessage().setHeader("Content-Type", (Object)"application/json");
        exchange.removeProperty("internalProperty_grpcServiceName");
        exchange.removeProperty("internalProperty_grpcMethodName");
    }

    private String extractBodyAsJsonString(Exchange exchange) throws InvalidProtocolBufferException, JsonProcessingException {
        Object body = exchange.getMessage().getBody();
        if (body instanceof List) {
            List list = (List)body;
            ArrayNode responses = this.objectMapper.createArrayNode();
            for (Object response : list) {
                String text = this.extractMessageAsJsonString(exchange, response);
                responses.add(this.objectMapper.readTree(text));
            }
            return this.objectMapper.writeValueAsString((Object)responses);
        }
        return this.extractMessageAsJsonString(exchange, body);
    }

    private String extractMessageAsJsonString(Exchange exchange, Object obj) throws InvalidProtocolBufferException {
        Message message = (Message)exchange.getContext().getTypeConverter().convertTo(Message.class, obj);
        return this.grpcPrinter.print((MessageOrBuilder)message);
    }
}

