/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.camel.processors;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import io.atlasmap.api.AtlasSession;
import io.atlasmap.core.DefaultAtlasContextFactory;
import io.atlasmap.core.DefaultAtlasFunctionResolver;
import io.atlasmap.json.v2.JsonDataSource;
import io.atlasmap.v2.AtlasMapping;
import io.atlasmap.v2.Audit;
import io.atlasmap.v2.AuditStatus;
import io.atlasmap.v2.DataSource;
import io.atlasmap.v2.DataSourceType;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.qubership.integration.platform.engine.mapper.atlasmap.CustomAtlasContext;
import org.qubership.integration.platform.engine.mapper.atlasmap.ValidationResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class MapperProcessor
implements Processor {
    private static final Logger log = LoggerFactory.getLogger(MapperProcessor.class);
    private static final String CAMEL_EXCHANGE_PROPERTY = "camelExchangeProperty";
    private static final String CAMEL_MESSAGE_HEADER = "current";
    private static final String CONTENT_TYPE_HEADER_NAME = "Content-Type";
    private static final String CONTENT_TYPE_JSON_VALUE = "application/json";
    private static final String CONTENT_TYPE_XML_VALUE = "application/xml";
    private static final String TARGET_DOC_ID = "target";
    private static final String SOURCE_DOC_ID = "source";
    private static final String VARIABLES_PROPERTY = "variables";
    private static final String UNABLE_TO_READ_PROPERTY_ERROR_MESSAGE = "Unable to read complex property: ";
    private final DefaultAtlasContextFactory factory;
    private final ObjectMapper objectMapper;
    @Value(value="${qip.mapper.cache-enabled}")
    private boolean cacheEnabled;

    @Autowired
    public MapperProcessor(@Qualifier(value="jsonMapper") ObjectMapper objectMapper) {
        DefaultAtlasFunctionResolver.getInstance();
        this.factory = DefaultAtlasContextFactory.getInstance();
        this.objectMapper = objectMapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(Exchange exchange) throws Exception {
        String mapping = (String)exchange.getProperty("internalProperty_mappingConfig", String.class);
        AtlasMapping atlasMapping = null;
        ValidationResult cachedValidationResult = null;
        if (this.cacheEnabled) {
            String mappingId = (String)exchange.getProperty("internalProperty_mappingId", String.class);
            if (StringUtils.isNotEmpty((CharSequence)mappingId)) {
                atlasMapping = (AtlasMapping)exchange.getContext().getRegistry().lookupByNameAndType(mappingId, AtlasMapping.class);
                cachedValidationResult = (ValidationResult)exchange.getContext().getRegistry().lookupByNameAndType(mappingId, ValidationResult.class);
                if (atlasMapping == null) {
                    atlasMapping = this.getAtlasMappingObj(mapping);
                    exchange.getContext().getRegistry().bind(mappingId, AtlasMapping.class, (Object)atlasMapping);
                }
            } else {
                log.warn("Mapping ID is missing from the configuration");
            }
        }
        if (atlasMapping == null) {
            atlasMapping = this.getAtlasMappingObj(mapping);
        }
        CustomAtlasContext context = new CustomAtlasContext(this.factory, atlasMapping);
        if (Objects.nonNull(cachedValidationResult)) {
            context.setCachedValidationResult(cachedValidationResult);
        }
        AtlasSession session = context.createSession();
        this.uploadProperties(exchange, session);
        this.setDataSourcesDocuments(exchange, atlasMapping, session);
        try {
            context.process(session);
        }
        finally {
            String mappingId;
            if (this.cacheEnabled && Objects.isNull(cachedValidationResult) && StringUtils.isNotEmpty((CharSequence)(mappingId = (String)exchange.getProperty("internalProperty_mappingId", String.class))) && Objects.nonNull(cachedValidationResult = context.getCachedValidationResult())) {
                exchange.getContext().getRegistry().bind(mappingId, ValidationResult.class, (Object)cachedValidationResult);
            }
        }
        this.logIssues(exchange, session);
        this.throwExceptionOnErrors(exchange, session);
        this.setUpOutputContentType(exchange, atlasMapping);
        this.downloadProperties(exchange, session);
        this.getDataSourcesDocuments(exchange, atlasMapping, session);
    }

    private AtlasMapping getAtlasMappingObj(String mappingConfig) throws IOException {
        String mapping = StringEscapeUtils.unescapeXml((String)mappingConfig);
        StringReader stringReader = new StringReader(mapping);
        return (AtlasMapping)this.objectMapper.readValue((Reader)stringReader, AtlasMapping.class);
    }

    private void throwExceptionOnErrors(Exchange exchange, AtlasSession session) throws Exception {
        Boolean throwException = (Boolean)exchange.getProperty("internalProperty_mappingThrowException", (Object)false, Boolean.class);
        if (throwException.booleanValue()) {
            this.throwExceptionOnTransformationErrors(session);
        }
        this.throwExceptionOnUnsupportedErrors(session);
    }

    private void logIssues(Exchange exchange, AtlasSession session) {
        String sessionId = (String)exchange.getProperty("internalProperty_sessionId", String.class);
        List audits = session.getAudits().getAudit();
        audits.stream().filter(audit -> AuditStatus.ERROR == audit.getStatus() || AuditStatus.WARN == audit.getStatus()).filter(audit -> !this.isValidByDesign((Audit)audit)).forEach(audit -> {
            AuditStatus status = audit.getStatus();
            String message = audit.getMessage();
            String path = audit.getPath();
            log.debug("Mapper issue for session {}. \nAudit message: {}\nIssue status: {}\nPath: {}", new Object[]{sessionId, message, status, path});
        });
    }

    private void uploadProperties(Exchange exchange, AtlasSession session) {
        Map propertiesMap = exchange.getProperties();
        Map headersMap = exchange.getMessage().getHeaders();
        session.getMapping().getProperties().getProperty().forEach(property -> {
            String propertyName = property.getName();
            if (property.getDataSourceType().equals((Object)DataSourceType.SOURCE)) {
                if (property.getScope().equals(CAMEL_EXCHANGE_PROPERTY) && propertiesMap.containsKey(propertyName)) {
                    session.getSourceProperties().put(propertyName, propertiesMap.get(propertyName));
                }
                if (property.getScope().equals(CAMEL_MESSAGE_HEADER) && headersMap.containsKey(propertyName)) {
                    session.getSourceProperties().put(propertyName, headersMap.get(propertyName));
                }
            }
            if (property.getDataSourceType().equals((Object)DataSourceType.TARGET)) {
                if (property.getScope().equals(CAMEL_EXCHANGE_PROPERTY) && propertiesMap.containsKey(propertyName)) {
                    session.getTargetProperties().put(propertyName, propertiesMap.get(propertyName));
                }
                if (property.getScope().equals(CAMEL_MESSAGE_HEADER) && headersMap.containsKey(propertyName)) {
                    session.getTargetProperties().put(propertyName, headersMap.get(propertyName));
                }
            }
        });
    }

    private void downloadProperties(Exchange exchange, AtlasSession session) {
        session.getMapping().getProperties().getProperty().forEach(property -> {
            if (property.getDataSourceType().equals((Object)DataSourceType.TARGET)) {
                Object propertyValue = session.getTargetProperties().get(property.getName());
                if (property.getScope().equals(CAMEL_EXCHANGE_PROPERTY) && propertyValue != null) {
                    exchange.getProperties().put(property.getName(), propertyValue);
                }
                if (property.getScope().equals(CAMEL_MESSAGE_HEADER) && propertyValue != null) {
                    exchange.getMessage().getHeaders().put(property.getName(), propertyValue);
                }
            }
        });
    }

    private void setDataSourcesDocuments(Exchange exchange, AtlasMapping atlasMapping, AtlasSession session) {
        String body = (String)exchange.getMessage().getBody(String.class);
        session.setSourceDocument(SOURCE_DOC_ID, (Object)body);
        atlasMapping.getDataSource().stream().filter(dataSource -> !dataSource.getId().equals(SOURCE_DOC_ID) && !dataSource.getId().equals(TARGET_DOC_ID)).filter(dataSource -> dataSource.getDataSourceType().equals((Object)DataSourceType.SOURCE)).forEach(propertyDataSource -> {
            String propertyName = propertyDataSource.getName();
            Object propertyValue = propertyName.equals(VARIABLES_PROPERTY) ? this.getVariablesPropertyValue((HashMap)exchange.getProperty(propertyName)) : exchange.getProperty(propertyName);
            try {
                session.setSourceDocument(propertyName, propertyValue != null ? this.objectMapper.writeValueAsString(propertyValue) : null);
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(UNABLE_TO_READ_PROPERTY_ERROR_MESSAGE.concat(propertyName), e);
            }
        });
    }

    private ObjectNode getVariablesPropertyValue(HashMap<String, String> variables) {
        ObjectNode rootObject = this.objectMapper.createObjectNode();
        variables.keySet().forEach(key -> {
            JsonNode valueObject;
            String value = (String)variables.get(key);
            try {
                valueObject = this.objectMapper.readTree(value);
            }
            catch (JsonProcessingException e) {
                valueObject = new TextNode(value);
            }
            rootObject.set(key, valueObject);
        });
        return rootObject;
    }

    private void getDataSourcesDocuments(Exchange exchange, AtlasMapping atlasMapping, AtlasSession session) {
        Object target = session.getTargetDocument(TARGET_DOC_ID);
        exchange.getMessage().setBody(target);
        atlasMapping.getDataSource().stream().filter(dataSource -> !dataSource.getId().equals(SOURCE_DOC_ID) && !dataSource.getId().equals(TARGET_DOC_ID)).filter(dataSource -> dataSource.getDataSourceType().equals((Object)DataSourceType.TARGET)).forEach(propertyDataSource -> {
            String propertyName = propertyDataSource.getName();
            Object propertyValue = session.getTargetDocument(propertyName);
            exchange.setProperty(propertyName, propertyValue);
        });
    }

    private void setUpOutputContentType(Exchange exchange, AtlasMapping atlasMapping) {
        DataSource targetDataSource = atlasMapping.getDataSource().stream().filter(dataSource -> dataSource.getDataSourceType().equals((Object)DataSourceType.TARGET)).findFirst().orElse((DataSource)new JsonDataSource());
        String targetContentType = targetDataSource instanceof JsonDataSource ? CONTENT_TYPE_JSON_VALUE : CONTENT_TYPE_XML_VALUE;
        exchange.getMessage().setHeader(CONTENT_TYPE_HEADER_NAME, (Object)targetContentType);
    }

    private void throwExceptionOnTransformationErrors(AtlasSession session) throws Exception {
        List<Audit> transformationErrors = session.getAudits().getAudit().stream().filter(this::isTransformationError).toList();
        if (!transformationErrors.isEmpty()) {
            String message = transformationErrors.stream().map(audit -> String.format("path: %s, message: \"%s\"", audit.getPath(), audit.getMessage())).collect(Collectors.joining("; ", "Failed to perform mapping: ", ""));
            throw new Exception(message);
        }
    }

    private boolean isTransformationError(Audit audit) {
        return AuditStatus.ERROR.equals((Object)audit.getStatus()) && (audit.getMessage().startsWith("Failed to apply field action: ") || audit.getMessage().startsWith("Failed to convert field value ") || audit.getMessage().startsWith("Expression processing error "));
    }

    private boolean isValidByDesign(Audit audit) {
        return AuditStatus.WARN.equals((Object)audit.getStatus()) && audit.getMessage().startsWith("The 0 index will be used for any extra parent collections in target") || AuditStatus.WARN.equals((Object)audit.getStatus()) && audit.getMessage().startsWith("Null or non-String source document") || AuditStatus.ERROR.equals((Object)audit.getStatus()) && audit.getMessage().startsWith("Cannot read field") && audit.getMessage().endsWith("document is null") || AuditStatus.ERROR.equals((Object)audit.getStatus()) && audit.getMessage().startsWith("Cannot read a field") && audit.getMessage().endsWith("document is null");
    }

    private void throwExceptionOnUnsupportedErrors(AtlasSession session) {
        List<Audit> transformationErrors = session.getAudits().getAudit().stream().filter(this::isUnsupportedError).toList();
        if (!transformationErrors.isEmpty()) {
            String message = transformationErrors.stream().map(audit -> String.format("path: %s, message: \"%s\"", audit.getPath(), audit.getMessage())).collect(Collectors.joining("; ", "Failed to perform mapping: ", ""));
            throw new UnsupportedOperationException(message);
        }
    }

    private boolean isUnsupportedError(Audit audit) {
        return AuditStatus.ERROR.equals((Object)audit.getStatus()) && audit.getMessage().startsWith("Nested JSON array is not supported");
    }

    public DefaultAtlasContextFactory getFactory() {
        return this.factory;
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public boolean isCacheEnabled() {
        return this.cacheEnabled;
    }

    public void setCacheEnabled(boolean cacheEnabled) {
        this.cacheEnabled = cacheEnabled;
    }
}

