/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.configuration;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.rabbitmq.client.LongString;
import org.jetbrains.annotations.NotNull;
import org.postgresql.jdbc.PgArray;
import org.qubership.integration.platform.engine.camel.components.rabbitmq.serializers.LongStringSerializer;
import org.qubership.integration.platform.engine.camel.processors.serializers.PgArraySerializer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class MapperConfiguration {
    @Bean(name={"objectMapper", "jsonMapper"})
    public ObjectMapper objectMapper() {
        return MapperConfiguration.buildObjectMapper();
    }

    @Bean(value={"checkpointMapper"})
    public ObjectMapper checkpointMapper() {
        ObjectMapper mapper = MapperConfiguration.buildObjectMapper();
        mapper.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
        return mapper;
    }

    @NotNull
    private static ObjectMapper buildObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule((Module)new JavaTimeModule());
        objectMapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        objectMapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        objectMapper.enable(SerializationFeature.INDENT_OUTPUT);
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        SimpleModule serializeModule = new SimpleModule();
        serializeModule.addSerializer(LongString.class, (JsonSerializer)new LongStringSerializer(LongString.class));
        serializeModule.addSerializer(PgArray.class, (JsonSerializer)new PgArraySerializer(PgArray.class));
        objectMapper.registerModule((Module)serializeModule);
        return objectMapper;
    }
}

