/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.configuration;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;

@Configuration
public class PredeployCheckKafkaConfiguration {
    private static final Logger log = LoggerFactory.getLogger(PredeployCheckKafkaConfiguration.class);
    @Value(value="${qip.camel.component.kafka.predeploy-check-enabled}")
    private boolean camelKafkaPredeployCheckEnabled;
    @Value(value="${qip.local-truststore.store.path}")
    private String truststoreLocation;
    @Value(value="${qip.local-truststore.store.password}")
    private String truststorePassword;

    public Map<String, Object> createValidationKafkaAdminConfig(String brokers, String securityProtocol, String saslMechanism, String saslJaasConfig) {
        HashMap<String, Object> config = new HashMap<String, Object>();
        config.put("bootstrap.servers", brokers);
        config.put("security.protocol", StringUtils.isEmpty((CharSequence)securityProtocol) ? "PLAINTEXT" : securityProtocol);
        config.put("sasl.mechanism", StringUtils.isEmpty((CharSequence)saslMechanism) ? "PLAIN" : saslMechanism);
        if (StringUtils.isNotEmpty((CharSequence)saslJaasConfig)) {
            config.put("sasl.jaas.config", saslJaasConfig);
        }
        config.put("socket.connection.setup.timeout.ms", 5000L);
        config.put("socket.connection.setup.timeout.max.ms", 5000L);
        config.put("request.timeout.ms", 5000);
        config.put("default.api.timeout.ms", 5000);
        config.put("ssl.truststore.location", this.truststoreLocation);
        config.put("ssl.truststore.password", this.truststorePassword);
        config.put("ssl.truststore.type", "JKS");
        return config;
    }

    public boolean isCamelKafkaPredeployCheckEnabled() {
        return this.camelKafkaPredeployCheckEnabled;
    }

    public String getTruststoreLocation() {
        return this.truststoreLocation;
    }

    public String getTruststorePassword() {
        return this.truststorePassword;
    }
}

