/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.configuration.datasource;

import com.zaxxer.hikari.HikariDataSource;
import jakarta.persistence.SharedCacheMode;
import jakarta.persistence.spi.PersistenceProvider;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.hibernate.jpa.HibernatePersistenceProvider;
import org.qubership.integration.platform.engine.configuration.datasource.properties.HikariConfigProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.orm.jpa.JpaProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Primary;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.orm.jpa.JpaVendorAdapter;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.orm.jpa.vendor.HibernateJpaVendorAdapter;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@AutoConfiguration
@EnableTransactionManagement
@EnableConfigurationProperties(value={JpaProperties.class, HikariConfigProperties.class})
@EnableJpaRepositories(basePackages={"org.qubership.integration.platform.engine.persistence.configs.repository"}, transactionManagerRef="schedulerTransactionManager")
public class PersistenceQuartzAutoConfiguration {
    private static final String JPA_ENTITIES_PACKAGE_SCAN = "org.qubership.integration.platform.engine.persistence.configs.entity";
    private final JpaProperties jpaProperties;
    private final HikariConfigProperties properties;

    @Autowired
    public PersistenceQuartzAutoConfiguration(JpaProperties jpaProperties, HikariConfigProperties properties) {
        this.jpaProperties = jpaProperties;
        this.properties = properties;
    }

    @Primary
    @Bean(value={"qrtzDataSource"})
    @ConditionalOnMissingBean(name={"qrtzDataSource"})
    public DataSource qrtzDataSource() {
        return new HikariDataSource(this.properties.getDatasource("qrtz-datasource"));
    }

    @Primary
    @Bean(value={"entityManagerFactory"})
    public LocalContainerEntityManagerFactoryBean schedulerEntityManagerFactory(DataSource qrtzDataSource) {
        LocalContainerEntityManagerFactoryBean em = new LocalContainerEntityManagerFactoryBean();
        HibernateJpaVendorAdapter jpaVendorAdapter = new HibernateJpaVendorAdapter();
        jpaVendorAdapter.setDatabase(this.jpaProperties.getDatabase());
        jpaVendorAdapter.setGenerateDdl(this.jpaProperties.isGenerateDdl());
        jpaVendorAdapter.setShowSql(this.jpaProperties.isShowSql());
        em.setDataSource(qrtzDataSource);
        em.setJpaVendorAdapter((JpaVendorAdapter)jpaVendorAdapter);
        em.setPackagesToScan(new String[]{JPA_ENTITIES_PACKAGE_SCAN});
        em.setPersistenceProvider((PersistenceProvider)new HibernatePersistenceProvider());
        em.setJpaProperties(this.additionalProperties());
        em.setSharedCacheMode(SharedCacheMode.ENABLE_SELECTIVE);
        return em;
    }

    @Primary
    @Bean(value={"schedulerTransactionManager"})
    public PlatformTransactionManager schedulerTransactionManager(@Qualifier(value="entityManagerFactory") LocalContainerEntityManagerFactoryBean schedulerEntityManagerFactory) {
        JpaTransactionManager transactionManager = new JpaTransactionManager();
        transactionManager.setEntityManagerFactory(schedulerEntityManagerFactory.getObject());
        return transactionManager;
    }

    private Properties additionalProperties() {
        Properties properties = new Properties();
        if (this.jpaProperties != null) {
            properties.putAll((Map<?, ?>)this.jpaProperties.getProperties());
        }
        return properties;
    }
}

