/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.configuration.opensearch;

import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.annotation.PostConstruct;
import java.io.IOException;
import java.lang.reflect.Field;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.opensearch.client.opensearch.OpenSearchClient;
import org.opensearch.client.opensearch._types.ExpandWildcard;
import org.opensearch.client.opensearch.indices.GetIndexRequest;
import org.opensearch.client.opensearch.indices.GetIndexResponse;
import org.opensearch.client.opensearch.indices.IndexSettings;
import org.opensearch.client.opensearch.indices.IndexState;
import org.opensearch.client.opensearch.indices.UpdateAliasesRequest;
import org.opensearch.client.opensearch.indices.update_aliases.Action;
import org.qubership.integration.platform.engine.IntegrationEngineApplication;
import org.qubership.integration.platform.engine.model.opensearch.OpenSearchFieldType;
import org.qubership.integration.platform.engine.opensearch.OpenSearchClientSupplier;
import org.qubership.integration.platform.engine.opensearch.annotation.OpenSearchDocument;
import org.qubership.integration.platform.engine.opensearch.annotation.OpenSearchField;
import org.qubership.integration.platform.engine.opensearch.ism.IndexStateManagementClient;
import org.qubership.integration.platform.engine.opensearch.ism.model.Conditions;
import org.qubership.integration.platform.engine.opensearch.ism.model.FailedIndex;
import org.qubership.integration.platform.engine.opensearch.ism.model.ISMTemplate;
import org.qubership.integration.platform.engine.opensearch.ism.model.Policy;
import org.qubership.integration.platform.engine.opensearch.ism.model.State;
import org.qubership.integration.platform.engine.opensearch.ism.model.Transition;
import org.qubership.integration.platform.engine.opensearch.ism.model.actions.DeleteAction;
import org.qubership.integration.platform.engine.opensearch.ism.model.actions.RolloverAction;
import org.qubership.integration.platform.engine.opensearch.ism.model.time.TimeValue;
import org.qubership.integration.platform.engine.opensearch.ism.rest.ISMStatusResponse;
import org.qubership.integration.platform.engine.opensearch.ism.rest.PolicyResponse;
import org.qubership.integration.platform.engine.opensearch.ism.rest.RequestHelper;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.util.ConfigurationBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

@Component
public class OpenSearchInitializer {
    private static final Logger log = LoggerFactory.getLogger(OpenSearchInitializer.class);
    public static final long TEMPLATE_VERSION = 4L;
    @Value(value="${qip.opensearch.index.elements.shards:3}")
    private int indexShardsAmount;
    @Value(value="${qip.opensearch.rollover.min_index_age:1d}")
    private TimeValue minIndexAge;
    @Value(value="${qip.opensearch.rollover.min_index_size:}")
    private String minIndexSize;
    @Value(value="${qip.opensearch.rollover.min_rollover_age_to_delete:14d}")
    private TimeValue minRolloverAgeToDelete;
    private final Environment environment;
    private final ObjectMapper jsonMapper;
    private final OpenSearchClientSupplier openSearchClientSupplier;

    public OpenSearchInitializer(Environment environment, @Qualifier(value="jsonMapper") ObjectMapper jsonMapper, OpenSearchClientSupplier openSearchClientSupplier) {
        this.environment = environment;
        this.jsonMapper = jsonMapper;
        this.openSearchClientSupplier = openSearchClientSupplier;
    }

    @PostConstruct
    public void initialize() {
        log.info("Update opensearch template and indexes");
        this.updateTemplateAndIndexes(this.openSearchClientSupplier.getClient());
    }

    private void updateTemplateAndIndexes(OpenSearchClient client) {
        String packageRoot = IntegrationEngineApplication.class.getPackage().getName();
        Set indexClasses = new Reflections((Configuration)new ConfigurationBuilder().forPackages(new String[]{packageRoot})).getTypesAnnotatedWith(OpenSearchDocument.class);
        for (Class indexClass : indexClasses) {
            OpenSearchDocument osd = indexClass.getAnnotation(OpenSearchDocument.class);
            String documentName = this.environment.getProperty(osd.documentNameProperty());
            if (documentName == null) {
                log.error("Failed to get document name from property {}. Skipping creation of policies, index template, and indices for {}.", (Object)osd.documentNameProperty(), (Object)indexClass.getName());
                continue;
            }
            log.info("Creating policies, index template, and indices for {} - {}.", (Object)indexClass.getName(), (Object)documentName);
            try {
                Map<String, Object> mapping = this.getIndexMapSource(indexClass);
                if (mapping.isEmpty()) continue;
                String prefix = this.openSearchClientSupplier.normalize(documentName);
                this.createOrUpdatePolicy(client, this.buildRolloverPolicy(prefix));
                this.updateTemplate(client, prefix, mapping);
                this.updateIndices(client, prefix, mapping);
            }
            catch (Exception exception) {
                log.error("Failed to create or update index template, policies, and indices for {}.", (Object)documentName, (Object)exception);
            }
        }
    }

    private void updateTemplate(OpenSearchClient client, String prefix, Map<String, Object> mapping) {
        String templateName = this.getIndexTemplateName(prefix);
        List<String> indexPatterns = this.getIndexPatterns(prefix);
        log.info("Updating index template {} for index pattern(s) {}.", (Object)templateName, (Object)String.join((CharSequence)", ", indexPatterns));
        try {
            HashMap<String, Object> request = new HashMap<String, Object>();
            request.put("index_patterns", indexPatterns);
            request.put("priority", 1);
            request.put("version", 4L);
            HashMap<String, Map<String, Object>> template = new HashMap<String, Map<String, Object>>();
            template.put("settings", this.getIndexSettings(prefix));
            template.put("mappings", mapping);
            request.put("template", template);
            RequestHelper.processHttpResponse(client.generic().execute(RequestHelper.buildPutIndexTemplateRequest(this.jsonMapper, templateName, request)));
        }
        catch (Exception e) {
            log.error("Failed to create or update OpenSearch template {} for index pattern(s) {}.", new Object[]{templateName, String.join((CharSequence)", ", indexPatterns), e});
        }
    }

    private void updateIndices(OpenSearchClient client, String prefix, Map<String, Object> mapping) {
        this.createOrUpdateRolloverIndices(client, prefix, mapping);
        this.updateOldIndex(client, this.getOldIndexName(prefix), this.getAliasName(prefix), mapping);
    }

    private void createOrUpdateRolloverIndices(OpenSearchClient client, String prefix, Map<String, Object> mapping) {
        List<String> indices;
        String mask = this.getIndexNameMask(prefix);
        try {
            log.info("Requesting indices that match mask {}.", (Object)mask);
            GetIndexRequest request = new GetIndexRequest.Builder().index(mask, new String[0]).expandWildcards(ExpandWildcard.Open, new ExpandWildcard[0]).build();
            GetIndexResponse response = client.indices().get(request);
            indices = response.result().keySet().stream().filter(name -> !name.equals(this.getOldIndexName(prefix))).toList();
        }
        catch (IOException exception) {
            log.error("Failed to get indices by mask {}.", (Object)mask, (Object)exception);
            return;
        }
        if (indices.isEmpty()) {
            log.info("Indices that match mask {} not found.", (Object)mask);
            this.createRolloverIndex(client, prefix, mapping);
        } else {
            log.info("Found {} indices that match mask: {}.", (Object)indices.size(), (Object)String.join((CharSequence)", ", indices));
            for (String indexName : indices) {
                this.updateIndexMapping(client, indexName, mapping);
                this.tryToAddPolicyToIndex(client, indexName, this.getRolloverPolicyId(prefix));
            }
        }
    }

    private void createRolloverIndex(OpenSearchClient client, String prefix, Map<String, Object> mapping) {
        String indexName = this.getFirstRolloverIndexName(prefix);
        log.info("Creating index {}.", (Object)indexName);
        try {
            HashMap<String, Object> request = new HashMap<String, Object>();
            request.put("settings", this.getIndexSettings(prefix));
            request.put("mappings", mapping);
            request.put("aliases", Map.of(this.getAliasName(prefix), Map.of("is_write_index", true)));
            RequestHelper.processHttpResponse(client.generic().execute(RequestHelper.buildCreateIndexRequest(this.jsonMapper, indexName, request)));
        }
        catch (IOException exception) {
            log.error("Failed to create index {}.", (Object)indexName, (Object)exception);
        }
    }

    @Deprecated(since="24.1")
    private void updateOldIndex(OpenSearchClient client, String indexName, String aliasName, Map<String, Object> mapping) {
        try {
            if (this.indexExists(client, indexName)) {
                this.updateIndexMapping(client, indexName, mapping);
                this.addIndexToAlias(client, indexName, aliasName);
                Instant creationTimestamp = this.getIndexCreationTimestamp(client, indexName);
                TimeValue minAge = this.calculateOldIndexMinAge(creationTimestamp);
                Policy policy = this.buildOldIndexRolloverPolicy(indexName, minAge);
                boolean created = this.createOrUpdatePolicy(client, policy);
                if (created) {
                    this.addPolicyToIndex(client, indexName, policy.getPolicyId());
                } else {
                    this.tryToAddPolicyToIndex(client, indexName, policy.getPolicyId());
                }
            }
        }
        catch (Exception exception) {
            log.error("Failed to update and add to alias index {}.", (Object)indexName, (Object)exception);
        }
    }

    private TimeValue calculateOldIndexMinAge(Instant creationTimestamp) {
        return Objects.isNull(this.minIndexAge) && Objects.isNull(this.minRolloverAgeToDelete) ? null : TimeValue.timeValueMillis(Instant.now().toEpochMilli() - creationTimestamp.toEpochMilli() + Optional.ofNullable(this.minRolloverAgeToDelete).map(TimeValue::millis).orElse(0L) + Optional.ofNullable(this.minIndexAge).map(TimeValue::millis).orElse(0L));
    }

    private void addPolicyToIndex(OpenSearchClient client, String indexName, String policyId) {
        log.info("Adding {} policy to index {}.", (Object)policyId, (Object)indexName);
        IndexStateManagementClient ismClient = new IndexStateManagementClient(client, this.jsonMapper);
        try {
            ISMStatusResponse response = ismClient.addPolicy(indexName, policyId);
            this.handleISMStatusResponse(response);
        }
        catch (Exception exception) {
            log.error("Failed to add policy to index {}.", (Object)indexName, (Object)exception);
        }
    }

    private void tryToAddPolicyToIndex(OpenSearchClient client, String indexName, String policyId) {
        log.info("Trying to add {} policy to index {}.", (Object)policyId, (Object)indexName);
        IndexStateManagementClient ismClient = new IndexStateManagementClient(client, this.jsonMapper);
        try {
            ismClient.addPolicy(indexName, policyId);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void handleISMStatusResponse(ISMStatusResponse response) throws Exception {
        if (response.getFailures().booleanValue()) {
            String message = Optional.ofNullable(response.getFailedIndices()).map(failedIndices -> failedIndices.stream().map(FailedIndex::getReason).filter(Objects::nonNull).collect(Collectors.joining(" "))).orElse("Unspecified error");
            throw new Exception(message);
        }
    }

    private boolean indexExists(OpenSearchClient client, String indexName) throws IOException {
        return client.indices().exists(builder -> builder.index(indexName, new String[0])).value();
    }

    private void updateIndexMapping(OpenSearchClient client, String indexName, Map<String, Object> mapping) {
        log.info("Updating index {}.", (Object)indexName);
        try {
            RequestHelper.processHttpResponse(client.generic().execute(RequestHelper.buildPutIndexMapping(this.jsonMapper, indexName, mapping)));
        }
        catch (IOException exception) {
            log.error("Failed to update index {}.", (Object)indexName, (Object)exception);
        }
    }

    private void addIndexToAlias(OpenSearchClient client, String indexName, String aliasName) {
        log.info("Adding index {} to alias {}.", (Object)indexName, (Object)aliasName);
        try {
            Action action = (Action)new Action.Builder().add(builder -> builder.index(indexName).alias(aliasName)).build();
            UpdateAliasesRequest request = new UpdateAliasesRequest.Builder().actions(action, new Action[0]).build();
            client.indices().updateAliases(request);
        }
        catch (IOException exception) {
            log.error("Failed to add index {} to alias {}.", new Object[]{indexName, aliasName, exception});
        }
    }

    private Map<String, Object> getIndexSettings(String prefix) {
        return Map.of("index.number_of_shards", this.indexShardsAmount, "plugins.index_state_management.rollover_alias", this.getAliasName(prefix));
    }

    private Map<String, Object> getIndexMapSource(Class<?> indexClass) {
        HashMap<String, Object> result = new HashMap<String, Object>(Map.of("dynamic", false, "date_detection", false, "numeric_detection", false));
        Map<String, Object> properties = this.getIndexMap(indexClass);
        if (!properties.isEmpty()) {
            result.put("properties", properties);
        }
        return result;
    }

    private Map<String, Object> getIndexMap(Class<?> indexClass) {
        Field[] fields;
        Map<String, Object> properties = new HashMap<String, Object>();
        if (indexClass == null) {
            return properties;
        }
        properties = this.getIndexMap(indexClass.getSuperclass());
        for (Field field : fields = indexClass.getDeclaredFields()) {
            String fieldName = field.getName();
            OpenSearchField annotation = field.getAnnotation(OpenSearchField.class);
            HashMap<String, Object> attributes = new HashMap<String, Object>();
            if (annotation != null) {
                attributes.put("type", annotation.type().toString().toLowerCase(Locale.ROOT));
                switch (annotation.type()) {
                    case Date: {
                        attributes.put("format", "date_optional_time||epoch_millis");
                        break;
                    }
                    case Object: {
                        attributes.put("properties", this.getIndexMap(field.getType()));
                    }
                }
            } else {
                Class<?> fieldClass = field.getType();
                if (fieldClass == String.class) {
                    attributes.put("type", OpenSearchFieldType.Text.toString().toLowerCase(Locale.ROOT));
                } else if (fieldClass == Integer.class || fieldClass == Integer.TYPE) {
                    attributes.put("type", OpenSearchFieldType.Integer.toString().toLowerCase(Locale.ROOT));
                } else if (fieldClass == Long.class || fieldClass == Long.TYPE) {
                    attributes.put("type", OpenSearchFieldType.Long.toString().toLowerCase(Locale.ROOT));
                } else if (fieldClass == Double.class || fieldClass == Double.TYPE) {
                    attributes.put("type", OpenSearchFieldType.Double.toString().toLowerCase(Locale.ROOT));
                } else if (fieldClass == Float.class || fieldClass == Float.TYPE) {
                    attributes.put("type", OpenSearchFieldType.Float.toString().toLowerCase(Locale.ROOT));
                } else if (fieldClass == Boolean.class || fieldClass == Boolean.TYPE) {
                    attributes.put("type", OpenSearchFieldType.Boolean.toString().toLowerCase(Locale.ROOT));
                } else {
                    throw new IllegalArgumentException(String.format("Unsupported type %s for OpenSearch index field %s. Please annotate this field manually via @OpenSearchField", fieldClass, fieldName));
                }
            }
            properties.put(fieldName, attributes);
        }
        return properties;
    }

    private boolean createOrUpdatePolicy(OpenSearchClient client, Policy policy) {
        IndexStateManagementClient ismClient = new IndexStateManagementClient(client, this.jsonMapper);
        try {
            Optional<PolicyResponse> responseOptional = ismClient.tryGetPolicy(policy.getPolicyId());
            if (responseOptional.isPresent()) {
                log.info("Updating policy {}.", (Object)policy.getPolicyId());
                PolicyResponse response = responseOptional.get();
                ismClient.updatePolicy(policy, response.getSeqNo(), response.getPrimaryTerm());
            } else {
                log.info("Creating policy {}.", (Object)policy.getPolicyId());
                ismClient.createPolicy(policy);
            }
            return responseOptional.isEmpty();
        }
        catch (IOException exception) {
            log.error("Failed to create or update index policy {}.", (Object)policy.getPolicyId(), (Object)exception);
            return false;
        }
    }

    private Policy buildOldIndexRolloverPolicy(String prefix, TimeValue minAge) {
        String policyId = this.getOldIndexRolloverPolicyId(prefix);
        ArrayList<Transition> transitions = new ArrayList<Transition>();
        if (Objects.nonNull(minAge)) {
            transitions.add(Transition.builder().stateName("delete").conditions(Conditions.builder().minIndexAge(minAge).build()).build());
        }
        if (StringUtils.isNotBlank((CharSequence)this.minIndexSize)) {
            transitions.add(Transition.builder().stateName("delete").conditions(Conditions.builder().minSize(this.minIndexSize).build()).build());
        }
        return Policy.builder().policyId(policyId).description("QIP old index rollover policy.").defaultState("schedule_to_delete").states(List.of(State.builder().name("schedule_to_delete").transitions(transitions).build(), State.builder().name("delete").actions(Collections.singletonList(DeleteAction.builder().build())).build())).build();
    }

    private Policy buildRolloverPolicy(String prefix) {
        String policyId = this.getRolloverPolicyId(prefix);
        String mask = this.getIndexNameMask(prefix);
        return Policy.builder().policyId(policyId).description("QIP " + mask + " rollover policy.").defaultState("rollover").states(List.of(State.builder().name("rollover").actions(Collections.singletonList(RolloverAction.builder().minIndexAge(this.minIndexAge).minSize(StringUtils.isNotBlank((CharSequence)this.minIndexSize) ? this.minIndexSize : null).build())).transitions(Collections.singletonList(Transition.builder().stateName("delete").conditions(Objects.isNull(this.minRolloverAgeToDelete) ? null : Conditions.builder().minRolloverAge(this.minRolloverAgeToDelete).build()).build())).build(), State.builder().name("delete").actions(Collections.singletonList(DeleteAction.builder().build())).build())).ismTemplate(Collections.singletonList(ISMTemplate.builder().indexPatterns(Collections.singletonList(mask)).build())).build();
    }

    private Instant getIndexCreationTimestamp(OpenSearchClient client, String indexName) throws IOException {
        GetIndexRequest request = new GetIndexRequest.Builder().index(indexName, new String[0]).build();
        GetIndexResponse response = client.indices().get(request);
        IndexSettings indexSettings = ((IndexState)response.result().get(indexName)).settings();
        return Instant.ofEpochMilli(Long.parseLong(indexSettings.creationDate()));
    }

    private List<String> getIndexPatterns(String prefix) {
        return List.of(this.getOldIndexNameMask(prefix), this.getIndexNameMask(prefix));
    }

    private String getOldIndexRolloverPolicyId(String prefix) {
        return prefix + "-old-index-rollover-policy";
    }

    private String getRolloverPolicyId(String prefix) {
        return prefix + "-rollover-policy";
    }

    private String getFirstRolloverIndexName(String prefix) {
        return prefix + "-000001";
    }

    private String getIndexNameMask(String prefix) {
        return prefix + "-*";
    }

    private String getOldIndexNameMask(String prefix) {
        return prefix;
    }

    private String getOldIndexName(String prefix) {
        return prefix;
    }

    private String getIndexTemplateName(String prefix) {
        return prefix + "_template";
    }

    private String getAliasName(String prefix) {
        return prefix + "-session-elements";
    }
}

