/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.configuration.web;

import org.eclipse.jetty.client.HttpClient;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.http.client.reactive.JettyClientHttpConnector;
import org.springframework.util.unit.DataSize;
import org.springframework.web.reactive.function.client.WebClient;

@Configuration
public class WebClientConfiguration {
    @Bean
    public HttpClient httpClient(@Value(value="${server.max-http-request-header-size}") DataSize maxHttpHeaderSize) {
        HttpClient client = new HttpClient();
        int bufferSize = Long.valueOf(maxHttpHeaderSize.toBytes()).intValue();
        client.setRequestBufferSize(bufferSize);
        return client;
    }

    @Bean
    public ClientHttpConnector clientHttpConnector(HttpClient httpClient) {
        return new JettyClientHttpConnector(httpClient);
    }

    @Bean
    public WebClient localhostWebclient(ClientHttpConnector clientHttpConnector) {
        return WebClient.builder().clientConnector(clientHttpConnector).baseUrl("http://localhost:8080").build();
    }
}

