/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.consul;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.qubership.integration.platform.engine.events.UpdateEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.event.ApplicationStartedEvent;
import org.springframework.context.event.EventListener;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

@Component
public class DeploymentReadinessService {
    private static final Logger log = LoggerFactory.getLogger(DeploymentReadinessService.class);
    public static final int CONSUMER_STARTUP_CHECK_DELAY_MILLIS = 20000;
    private final ConcurrentMap<Class<? extends UpdateEvent>, Boolean> receivedEvents;
    private boolean readyForDeploy = false;
    private boolean initialized = false;

    @Autowired
    public DeploymentReadinessService(@Qualifier(value="deploymentReadinessEvents") Set<Class<? extends UpdateEvent>> events) {
        if (log.isDebugEnabled()) {
            String eventClassNames = events.stream().map(Class::getSimpleName).collect(Collectors.joining(", "));
            log.debug("Required events to start deployments processing: {}", (Object)eventClassNames);
        }
        this.receivedEvents = new ConcurrentHashMap<Class, Boolean>(events.stream().collect(Collectors.toMap(event -> event, event -> false)));
    }

    @Async
    @EventListener(value={ApplicationStartedEvent.class})
    public void onApplicationStarted() {
        try {
            Thread.sleep(20000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (!this.isRequiredEventsReceived()) {
            Map<String, Boolean> outputMap = this.receivedEvents.entrySet().stream().collect(Collectors.toMap(entry -> ((Class)entry.getKey()).getSimpleName(), Map.Entry::getValue));
            log.error("At least one required event was not received (for this time) to start deployments processing!Events status: {}", outputMap);
        }
    }

    @EventListener
    public synchronized void onUpdateEvent(UpdateEvent event) {
        Class<?> cls = ((Object)((Object)event)).getClass();
        if (event.isInitialUpdate() && this.receivedEvents.containsKey(cls)) {
            log.debug("Initial UpdateEvent received: {}", (Object)cls.getSimpleName());
            this.receivedEvents.put(cls, true);
            this.checkAndStartDeploymentUpdatesConsumer();
        }
    }

    private synchronized void checkAndStartDeploymentUpdatesConsumer() {
        if (!this.readyForDeploy && this.isRequiredEventsReceived()) {
            log.info("Required events to start deployment updates consumer received successfully");
            this.readyForDeploy = true;
        }
    }

    private boolean isRequiredEventsReceived() {
        return this.receivedEvents.entrySet().stream().allMatch(Map.Entry::getValue);
    }

    public boolean isReadyForDeploy() {
        return this.readyForDeploy;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void setInitialized(boolean initialized) {
        this.initialized = initialized;
    }
}

