/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.errorhandling.errorcode;

import jakarta.annotation.Nullable;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import lombok.NonNull;
import org.qubership.integration.platform.engine.camel.components.servlet.exception.ChainGlobalExceptionHandler;
import org.qubership.integration.platform.engine.camel.components.servlet.exception.annotations.ChainExceptionHandler;
import org.qubership.integration.platform.engine.errorhandling.errorcode.ErrorCodePrefix;
import org.qubership.integration.platform.engine.model.errorhandling.ErrorCodePayload;

public enum ErrorCode {
    UNEXPECTED_BUSINESS_ERROR("0001", 500, "Chain execution failed due to unexpected business error", "Unexpected Business error"),
    REQUEST_VALIDATION_ERROR("0100", 400, "Request has not passed input validations, configured within requested chain", "Chain failed during request validation."),
    REQUESTED_ENDPOINT_NOT_FOUND("0101", 500, "Endpoint specified within a chain not found", "Chain execution failed due to requesting missing endpoint"),
    LOOP_ITERATIONS_LIMIT_REACHED("0102", 500, "Maximum number of iterations reached for 'Loop' element type", "Chain execution failed due to reaching maximum number of iterations"),
    SOCKET_TIMEOUT("0103", 500, "Endpoint specified within a chain timed out", "Chain execution failed due to reaching the timeout for the requested service"),
    SERVICE_RETURNED_ERROR("0104", 500, "Service returned error", "Chain execution failed after receiving the error from service"),
    KAFKA_TIMEOUT("0105", 500, "Unable to reach Kafka broker or topic", "Chain execution failed due to inability to reach Kafka"),
    CHAIN_ENDPOINT_NOT_FOUND("0106", 404, "Endpoint not found", "Chain request was rejected due to missing endpoint"),
    AUTHORIZATION_ERROR("0107", 403, "Request has not passed chain's access control settings", "Chain request was rejected due to access denial"),
    METHOD_NOT_ALLOWED("0108", 405, "Request method ${httpMethod} is not supported", "Chain request was rejected due to invalid method"),
    SDS_JOB_FINISHED_NOTIFICATION_ERROR("0109", "Unable to notify SDS regarding job instance finished for Job execution id: ${sdsJobExecutionId}", "SDS task execution failed due to inability to pass finish notification"),
    SDS_EXECUTION_INTERNAL_ERROR("0110", "SDS Job ${sdsJobExecutionId} execution failed", "SDS task execution failed due to internal error"),
    SDS_MISSING_JOB_ID("0111", "SDS Job ${sdsJobExecutionId} execution failed. No deployed chains with specified jobId", "SDS task execution failed due to missing jobId"),
    RESPONSE_VALIDATION_ERROR("0112", 500, "Response captured by one of the service calls has not passed configured validations", "Chain failed due to receiving unexpected response from service"),
    TIMEOUT_REACHED("0113", 500, "Chain timeout reached", "Chain execution failed due to reaching execution timeout"),
    FORCE_TERMINATED("0114", 500, "Chain session was shut down", "Chain execution was stopped manually"),
    PREDEPLOY_CHECK_ERROR("7103", "", "Predeploy check failed"),
    UNEXPECTED_DEPLOYMENT_ERROR("1500", "Error during deployment ${deploymentId} processing", "Unexpected deployment error"),
    DEPLOYMENT_START_ERROR("1501", "Deployment ${deploymentId} was not initialized correctly during pod startup", "Deployment initialization failed");

    private final int httpErrorCode;
    private final ErrorCodePayload payload;

    private ErrorCode(String code, String message) {
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        this.httpErrorCode = 0;
        this.payload = new ErrorCodePayload(code, message);
    }

    private ErrorCode(String code, String message, String reason) {
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        this.httpErrorCode = 0;
        this.payload = new ErrorCodePayload(code, message, reason);
    }

    private ErrorCode(@NonNull String code, int httpErrorCode, String message) {
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        this.httpErrorCode = httpErrorCode;
        this.payload = new ErrorCodePayload(code, message);
    }

    private ErrorCode(@NonNull String code, int httpErrorCode, String message, String reason) {
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        this.httpErrorCode = httpErrorCode;
        this.payload = new ErrorCodePayload(code, message, reason);
    }

    public String getCode() {
        return this.getPayload().getCode();
    }

    public String getFormattedCode() {
        return String.format("%s-%s", ErrorCodePrefix.getCodePrefix(), this.getPayload().getCode());
    }

    @Nullable
    public static ErrorCode match(@Nullable Throwable exception) {
        return exception == null ? null : ErrorCode.match(exception.getClass());
    }

    @Nullable
    private static ErrorCode match(Class<? extends Throwable> clazz) {
        Method[] methods = ChainGlobalExceptionHandler.class.getDeclaredMethods();
        ErrorCode defaultErrorCode = null;
        for (Method method : methods) {
            ChainExceptionHandler annotation = method.getAnnotation(ChainExceptionHandler.class);
            if (annotation == null) continue;
            if (annotation.value().length == 0) {
                defaultErrorCode = annotation.errorCode();
                continue;
            }
            if (!Arrays.asList(annotation.value()).contains(clazz)) continue;
            return annotation.errorCode();
        }
        return defaultErrorCode;
    }

    public String compileMessage(String ... messageParams) {
        String message = this.getMessage();
        List<String> extraKeys = this.getPayload().getExtraKeys();
        if (this.getMessage() != null && extraKeys.size() == messageParams.length) {
            for (int i = 0; i < extraKeys.size(); ++i) {
                String paramKey = extraKeys.get(i);
                message = message.replace("${" + paramKey + "}", messageParams[i]);
            }
        }
        return message;
    }

    public String getMessage() {
        return this.getPayload().getMessage();
    }

    public int getHttpErrorCode() {
        return this.httpErrorCode;
    }

    public ErrorCodePayload getPayload() {
        return this.payload;
    }
}

