/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.mapper.atlasmap;

import io.atlasmap.api.AtlasException;
import io.atlasmap.core.AtlasUtil;
import io.atlasmap.core.BaseAtlasModule;
import io.atlasmap.core.validate.BaseModuleValidationService;
import io.atlasmap.spi.AtlasFieldWriter;
import io.atlasmap.spi.AtlasInternalSession;
import io.atlasmap.spi.AtlasModuleDetail;
import io.atlasmap.v2.AtlasModelFactory;
import io.atlasmap.v2.AuditStatus;
import io.atlasmap.v2.DataSourceType;
import io.atlasmap.v2.Document;
import io.atlasmap.v2.Field;
import io.atlasmap.v2.FieldGroup;
import io.atlasmap.v2.Fields;
import io.atlasmap.xml.inspect.XmlInspectionException;
import io.atlasmap.xml.inspect.XmlInspectionService;
import io.atlasmap.xml.module.XmlModule;
import io.atlasmap.xml.v2.AtlasXmlModelFactory;
import io.atlasmap.xml.v2.XmlComplexType;
import io.atlasmap.xml.v2.XmlDataSource;
import io.atlasmap.xml.v2.XmlNamespace;
import io.atlasmap.xml.v2.XmlNamespaces;
import java.io.ByteArrayInputStream;
import java.util.HashMap;
import java.util.List;
import java.util.function.BiFunction;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.qubership.integration.platform.engine.mapper.atlasmap.ComplexMappingAtlasModule;
import org.qubership.integration.platform.engine.mapper.atlasmap.QipXmlValidationService;
import org.qubership.integration.platform.engine.mapper.atlasmap.xml.QipAtlasXmlFieldWriter;

@AtlasModuleDetail(name="QipXmlAtlasModule", uri="atlas:cip:xml", modes={"SOURCE", "TARGET"}, dataFormats={"xml"}, configPackages={"org.qubership.integration.platform.engine.mapper.atlasmap"})
public class QipXmlAtlasModule
extends ComplexMappingAtlasModule {
    private final XmlInspectionService inspectionService = new XmlInspectionService();

    public QipXmlAtlasModule() {
        super((BaseAtlasModule)new XmlModule(){

            protected org.w3c.dom.Document convertToXmlDocument(String source, boolean namespaced) throws AtlasException {
                if (source == null || source.isEmpty()) {
                    return null;
                }
                try {
                    DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                    dbf.setNamespaceAware(namespaced);
                    DocumentBuilder b = dbf.newDocumentBuilder();
                    return b.parse(new ByteArrayInputStream(source.getBytes("UTF-8")));
                }
                catch (Exception e) {
                    throw new AtlasException("Failed to parse XML document: " + e.getMessage(), (Throwable)e);
                }
            }
        });
    }

    @Override
    protected BaseModuleValidationService<?> getValidationService() {
        return new QipXmlValidationService(this.getClass().getAnnotation(AtlasModuleDetail.class), this.getConversionService(), this.getFieldActionService());
    }

    @Override
    protected BiFunction<AtlasInternalSession, String, Document> getInspectionService() {
        return (session, source) -> {
            try {
                return this.convertComplexObjectsToFieldGroups((Document)this.inspectionService.inspectXmlDocument(source));
            }
            catch (XmlInspectionException exception) {
                AtlasUtil.addAudit((AtlasInternalSession)session, (String)this.getDocId(), (String)exception.getMessage(), (AuditStatus)AuditStatus.ERROR, (String)"");
                return AtlasXmlModelFactory.createXmlDocument();
            }
        };
    }

    @Override
    public void processPreTargetExecution(AtlasInternalSession session) throws AtlasException {
        XmlNamespaces xmlNs = null;
        String template = null;
        for (Object ds : session.getMapping().getDataSource()) {
            if (!DataSourceType.TARGET.equals((Object)ds.getDataSourceType()) || !(ds instanceof XmlDataSource) || ds.getId() != null && !ds.getId().equals(this.getDocId())) continue;
            xmlNs = ((XmlDataSource)ds).getXmlNamespaces();
            template = ((XmlDataSource)ds).getTemplate();
        }
        HashMap<String, String> nsMap = new HashMap<String, String>();
        if (xmlNs != null && xmlNs.getXmlNamespace() != null && !xmlNs.getXmlNamespace().isEmpty()) {
            for (XmlNamespace ns : xmlNs.getXmlNamespace()) {
                nsMap.put(ns.getAlias(), ns.getUri());
            }
        }
        QipAtlasXmlFieldWriter writer = new QipAtlasXmlFieldWriter(this.getClassLoader(), nsMap, template);
        session.setFieldWriter(this.getDocId(), (AtlasFieldWriter)writer);
    }

    private Document convertComplexObjectsToFieldGroups(Document document) throws XmlInspectionException {
        List documentFields = document.getFields().getField();
        if (documentFields.isEmpty() || !(documentFields.get(documentFields.size() - 1) instanceof XmlComplexType)) {
            throw new XmlInspectionException("Failed to extract document field");
        }
        Fields fields = new Fields();
        ((XmlComplexType)documentFields.get(documentFields.size() - 1)).getXmlFields().getXmlField().stream().map(this::processComplexFields).forEach(fields.getField()::add);
        document.setFields(fields);
        return document;
    }

    private Field processComplexFields(Field field) {
        if (field instanceof XmlComplexType) {
            XmlComplexType complexType = (XmlComplexType)field;
            FieldGroup group = new FieldGroup();
            AtlasModelFactory.copyField((Field)complexType, (Field)group, (boolean)true);
            group.setValue(group.getValue());
            complexType.getXmlFields().getXmlField().stream().map(this::processComplexFields).forEach(group.getField()::add);
            return group;
        }
        return field;
    }
}

