/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.mapper.atlasmap.expressions;

import io.atlasmap.core.AtlasUtil;
import io.atlasmap.core.DefaultAtlasExpressionProcessor;
import io.atlasmap.core.DefaultAtlasFunctionResolver;
import io.atlasmap.core.DefaultAtlasSession;
import io.atlasmap.expression.Expression;
import io.atlasmap.expression.ExpressionException;
import io.atlasmap.expression.FunctionResolver;
import io.atlasmap.spi.AtlasInternalSession;
import io.atlasmap.spi.AtlasModule;
import io.atlasmap.v2.AtlasModelFactory;
import io.atlasmap.v2.AuditStatus;
import io.atlasmap.v2.ConstantField;
import io.atlasmap.v2.Field;
import io.atlasmap.v2.FieldGroup;
import io.atlasmap.v2.PropertyField;
import io.atlasmap.v2.SimpleField;
import java.lang.invoke.CallSite;
import java.util.HashMap;
import java.util.Map;
import org.qubership.integration.platform.engine.mapper.atlasmap.expressions.CustomExpression;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomAtlasExpressionProcessor
extends DefaultAtlasExpressionProcessor {
    private static final Logger log = LoggerFactory.getLogger(CustomAtlasExpressionProcessor.class);

    public static void processExpression(DefaultAtlasSession session, String expression) {
        block8: {
            if (expression == null || expression.trim().isEmpty()) {
                return;
            }
            try {
                Expression parsedExpression;
                Field answer;
                HashMap<CallSite, Field> sourceFieldMap = new HashMap<CallSite, Field>();
                Field parent = session.head().getSourceField();
                if (parent != null && !AtlasUtil.isEmpty((String)parent.getDocId()) && !AtlasUtil.isEmpty((String)parent.getPath())) {
                    sourceFieldMap.put((CallSite)((Object)(parent.getDocId() + ":" + parent.getPath())), parent);
                }
                if (parent instanceof FieldGroup && AtlasUtil.isEmpty((String)parent.getPath())) {
                    FieldGroup parentGroup = (FieldGroup)FieldGroup.class.cast(parent);
                    for (Field child : parentGroup.getField()) {
                        if (AtlasUtil.isEmpty((String)child.getDocId()) && AtlasUtil.isEmpty((String)child.getPath())) continue;
                        sourceFieldMap.put((CallSite)((Object)(child.getDocId() + ":" + child.getPath())), child);
                    }
                }
                if ((answer = (parsedExpression = CustomExpression.parse(expression, (FunctionResolver)DefaultAtlasFunctionResolver.getInstance())).evaluate(path -> {
                    if (path == null || path.isEmpty()) {
                        return null;
                    }
                    try {
                        AtlasModule sourceModule;
                        Field f = (Field)sourceFieldMap.get(path);
                        if (f == null) {
                            return null;
                        }
                        Map sourceModules = session.getAtlasContext().getSourceModules();
                        if (f instanceof ConstantField) {
                            sourceModule = (AtlasModule)sourceModules.get("ATLAS_CONSTANTS_DOC");
                        } else if (f instanceof PropertyField) {
                            sourceModule = (AtlasModule)sourceModules.get("ATLAS_SOURCE_PROPERTIES_DOC");
                        } else {
                            String[] splitted = path.split(":", 2);
                            sourceModule = (AtlasModule)sourceModules.get(splitted[0]);
                        }
                        if (sourceModule == null) {
                            throw new ExpressionException(String.format("Module for the path '%s' is not found", path));
                        }
                        session.head().setSourceField(f);
                        sourceModule.readSourceValue((AtlasInternalSession)session);
                        return session.head().getSourceField();
                    }
                    catch (Exception e) {
                        throw new ExpressionException((Throwable)e);
                    }
                })) instanceof Field) {
                    session.head().setSourceField(answer);
                } else {
                    Field from = session.head().getSourceField();
                    SimpleField to = new SimpleField();
                    AtlasModelFactory.copyField((Field)from, (Field)to, (boolean)false);
                    to.setValue((Object)answer);
                    session.head().setSourceField((Field)to);
                }
            }
            catch (Exception e) {
                AtlasUtil.addAudit((AtlasInternalSession)session, (String)expression, (String)String.format("Expression processing error [%s]: %s", expression, e.getMessage()), (AuditStatus)AuditStatus.ERROR, null);
                if (!log.isDebugEnabled()) break block8;
                log.debug("", (Throwable)e);
            }
        }
    }
}

