/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.mapper.atlasmap.functions;

import io.atlasmap.expression.ExpressionContext;
import io.atlasmap.expression.ExpressionException;
import io.atlasmap.v2.Field;
import io.atlasmap.v2.FieldGroup;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.qubership.integration.platform.mapper.ComplexField;

public class MapBasedExpressionContext
implements ExpressionContext {
    private final Map<String, Field> variableMap;

    public MapBasedExpressionContext(Map<String, Field> variableMap) {
        this.variableMap = variableMap;
    }

    public Field getVariable(String s) throws ExpressionException {
        return this.variableMap.get(s);
    }

    public static MapBasedExpressionContext fromField(Field field, Function<String, String> pathMapper) {
        return new MapBasedExpressionContext(MapBasedExpressionContext.createFieldMap(field, pathMapper));
    }

    public static Map<String, Field> createFieldMap(Field field, Function<String, String> pathMapper) {
        HashMap<String, Field> map = new HashMap<String, Field>();
        String name = MapBasedExpressionContext.buildVariableName(field, pathMapper);
        map.put(name, field);
        if (field instanceof FieldGroup) {
            FieldGroup group = (FieldGroup)field;
            group.getField().stream().map(f -> MapBasedExpressionContext.createFieldMap(f, pathMapper)).forEach(map::putAll);
        } else if (field instanceof ComplexField) {
            ComplexField complexField = (ComplexField)field;
            complexField.getChildFields().stream().map(f -> MapBasedExpressionContext.createFieldMap(f, pathMapper)).forEach(map::putAll);
        }
        return map;
    }

    private static String buildVariableName(Field field, Function<String, String> pathMapper) {
        return field.getDocId() + ":" + pathMapper.apply(field.getPath());
    }
}

