/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.mapper.atlasmap.json;

import io.atlasmap.json.inspect.JsonInspectionException;
import io.atlasmap.json.inspect.JsonInspectionService;
import io.atlasmap.json.inspect.JsonSchemaInspector;
import io.atlasmap.json.v2.JsonDocument;
import org.apache.commons.lang3.StringUtils;
import org.qubership.integration.platform.engine.mapper.atlasmap.json.QipJsonInstanceInspector;

public class QipJsonInspectionService
extends JsonInspectionService {
    private QipJsonInstanceInspector jsonInstanceInspector;

    public QipJsonInspectionService(QipJsonInstanceInspector jsonInstanceInspector) {
        this.jsonInstanceInspector = jsonInstanceInspector;
    }

    public JsonDocument inspectJsonDocument(String sourceDocument) throws JsonInspectionException {
        return StringUtils.isBlank((CharSequence)sourceDocument) ? new JsonDocument() : this.doInspectJsonDocument(sourceDocument);
    }

    public JsonDocument inspectJsonSchema(String jsonSchema) throws JsonInspectionException {
        return StringUtils.isBlank((CharSequence)jsonSchema) ? new JsonDocument() : this.doInspectJsonSchema(jsonSchema);
    }

    protected JsonDocument doInspectJsonDocument(String sourceDocument) throws JsonInspectionException {
        if (sourceDocument == null || sourceDocument.isEmpty() || sourceDocument.trim().isEmpty()) {
            throw new IllegalArgumentException("Source document cannot be null, empty or contain only whitespace.");
        }
        String cleanDocument = this.cleanJsonDocument(sourceDocument);
        if (cleanDocument.startsWith("{") || cleanDocument.startsWith("[")) {
            return this.jsonInstanceInspector.inspect(cleanDocument);
        }
        throw new JsonInspectionException("JSON data must begin with either '{' or '['");
    }

    protected JsonDocument doInspectJsonSchema(String jsonSchema) throws JsonInspectionException {
        if (jsonSchema == null || jsonSchema.isEmpty() || jsonSchema.trim().isEmpty()) {
            throw new IllegalArgumentException("Schema cannot be null, empty or contain only whitespace.");
        }
        String cleanDocument = this.cleanJsonDocument(jsonSchema);
        if (cleanDocument.startsWith("{") || cleanDocument.startsWith("[")) {
            return JsonSchemaInspector.instance().inspect(cleanDocument);
        }
        throw new JsonInspectionException("JSON schema must begin with either '{' or '['");
    }
}

