/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.model.constants;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.apache.camel.Exchange;
import org.apache.camel.component.springrabbit.SpringRabbitMQConstants;

public final class CamelConstants {
    private static final Set<String> INTERNAL_PROPERTIES_NAMES;
    private static final Set<String> INTERNAL_HEADERS_NAMES;
    public static final String INTERNAL_PROPERTY_PREFIX = "internalProperty_";
    public static final String SYSTEM_PROPERTY_PREFIX = "systemProperty_";
    public static final String LOG_TYPE_KEY = "logType";
    public static final String LOG_TYPE_VALUE = "int";
    public static final String MASKING_TEMPLATE = "******";
    public static final String UUID_REGEXP_STRING = "[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}";
    public static final Pattern UUID_STEP_REG_EXP_PATTERN;
    public static final String STEP_NAME_ID_PATTERN = "^[\\s\\S]{0,}--";
    public static final Pattern NAME_STEP_REG_EXP_PATTERN;
    public static final Pattern CUSTOM_STEP_ID_PATTERN;

    public static boolean isInternalProperty(String key) {
        return INTERNAL_PROPERTIES_NAMES.contains(key) || key != null && key.startsWith(INTERNAL_PROPERTY_PREFIX);
    }

    public static boolean isInternalHeader(String header) {
        return INTERNAL_HEADERS_NAMES.contains(header);
    }

    private static void extractPublicStringFieldsToMap(Set<String> internalProperties, Class<?> aClass) throws IllegalAccessException {
        for (Field field : aClass.getDeclaredFields()) {
            if (!Modifier.isPublic(field.getModifiers()) || !field.getType().getSimpleName().equals("String")) continue;
            internalProperties.add((String)field.get(aClass));
        }
    }

    private CamelConstants() {
    }

    static {
        UUID_STEP_REG_EXP_PATTERN = Pattern.compile("--[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}$", 2);
        NAME_STEP_REG_EXP_PATTERN = Pattern.compile(STEP_NAME_ID_PATTERN, 2);
        CUSTOM_STEP_ID_PATTERN = Pattern.compile("^[\\s\\S]{0,}--[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}$", 2);
        TreeSet<String> exchangeProperties = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        TreeSet<String> internalProperties = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        TreeSet<String> internalHeaders = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        try {
            CamelConstants.extractPublicStringFieldsToMap(internalProperties, Properties.class);
            CamelConstants.extractPublicStringFieldsToMap(exchangeProperties, Exchange.class);
            CamelConstants.extractPublicStringFieldsToMap(exchangeProperties, SpringRabbitMQConstants.class);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Failed to initialize internal properties/headers map in static block", e);
        }
        internalProperties.addAll(exchangeProperties);
        internalHeaders.addAll(exchangeProperties);
        internalProperties.remove("originalSessionId");
        internalProperties.remove("parentSessionId");
        internalProperties.add("OpenTracing.activeSpan");
        INTERNAL_PROPERTIES_NAMES = Collections.unmodifiableSet(internalProperties);
        internalHeaders.addAll(Set.of("external-session-cip-id", "CamelGraphQLVariables", "scheduler", "jobDetail", "trigger", "jobInstance"));
        INTERNAL_HEADERS_NAMES = Collections.unmodifiableSet(internalHeaders);
    }

    public static final class Properties {
        public static final String ELEMENT_EXECUTION_MAP = "internalProperty_elementExecutionMap";
        public static final String SESSION_ID = "internalProperty_sessionId";
        public static final String SESSION_SHOULD_BE_LOGGED = "internalProperty_sessionShouldBeLogged";
        public static final String STEPS = "internalProperty_steps";
        public static final String EXCHANGES = "internalProperty_exchanges";
        public static final String START_TIME = "internalProperty_startTime";
        public static final String START_TIME_MS = "internalProperty_startTimeMs";
        public static final String EXCHANGE_START_TIME_MS = "internalProperty_exchangeStartTimeMs";
        public static final String IS_MAIN_EXCHANGE = "internalProperty_isMainExchange";
        public static final String ELEMENT_FAILED = "internalProperty_elementFailed";
        public static final String LAST_EXCEPTION = "internalProperty_lastException";
        public static final String LAST_EXCEPTION_ERROR_CODE = "internalProperty_laseExceptionErrorCode";
        public static final String TRACE_ME = "TraceMe";
        public static final String REQUEST_CONTEXT_PROPAGATION_SNAPSHOT = "internalProperty_requestContextPropagationSnapshot";
        public static final String TRACING_CUSTOM_TAGS = "internalProperty_tracingCustomTags";
        public static final String VARIABLES_PROPERTY_MAP_NAME = "variables";
        public static final String CIRCUIT_BREAKER_HAS_FALLBACK = "internalProperty_circuitBreaker_hasFallback";
        public static final String ELEMENT_WARNING = "internalProperty_element_warning";
        public static final String OVERALL_STATUS_WARNING = "internalProperty_overall_status_warning";
        public static final String CHECKPOINT_ORIGINAL_SESSION_ID = "originalSessionId";
        public static final String CHECKPOINT_PARENT_SESSION_ID = "parentSessionId";
        public static final String CHECKPOINT_INTERNAL_ORIGINAL_SESSION_ID = "internalProperty_originalSessionId";
        public static final String CHECKPOINT_INTERNAL_PARENT_SESSION_ID = "internalProperty_parentSessionId";
        public static final String CHECKPOINT_ELEMENT_ID = "internalProperty_checkpointElementId";
        public static final String CHECKPOINT_IS_TRIGGER_STEP = "internalProperty_isCheckpointTriggerStep";
        public static final String CURRENT_REUSE_REFERENCE_PARENT_ID = "internalProperty_%s_currentReuseReferenceParentId";
        public static final String REUSE_HAS_INTERMEDIATE_PARENTS = "internalProperty_%s_hasIntermediateParents";
        public static final String SPLIT_ID = "internalProperty_splitId";
        public static final String SPLIT_ID_CHAIN = "internalProperty_splitIdChain";
        public static final String SPLIT_BRANCH_TYPE = "internalProperty_splitBranchType";
        public static final String SPLIT_EXCHANGE_HEADER_PROCESSED = "internalProperty_splitExchangeHeaderProcessed";
        public static final String SPLIT_EXCHANGE_PROPERTIES_PROCESSED = "internalProperty_exchangePropertiesProcessed";
        public static final String SPLIT_PROPAGATE_HEADERS = "internalProperty_propagateHeaders";
        public static final String SPLIT_PROPAGATE_PROPERTIES = "internalProperty_propagateProperties";
        public static final String SPLIT_PROCESSED = "internalProperty_splitProcessed";
        public static final String CLASSIFIER = "internalProperty_classifier";
        public static final String SCRIPT = "internalProperty_script";
        public static final String DATA_RETURNING = "internalProperty_dataReturningQuery";
        public static final String BODY_MIME_TYPE = "internalProperty_bodyMimeType";
        public static final String BODY_FORM_DATA = "internalProperty_bodyFormData";
        public static final String GQL_VARIABLES_JSON = "internalProperty_graphQLVariablesJSON";
        public static final String VALIDATION_SCHEMA = "internalProperty_validationSchema";
        public static final String EXPECTED_CONTENT_TYPE = "internalProperty_expectedContentType";
        public static final String MATCHED_CONTENT_TYPES = "internalProperty_contentTypeMatched";
        public static final String ASYNC_VALIDATION_SCHEMA = "internalProperty_asyncValidationSchema";
        public static final String GRPC_SERVICE_NAME = "internalProperty_grpcServiceName";
        public static final String GRPC_METHOD_NAME = "internalProperty_grpcMethodName";
        public static final String MAPPING_THROW_EXCEPTION = "internalProperty_mappingThrowException";
        public static final String MAPPING_CONFIG = "internalProperty_mappingConfig";
        public static final String MAPPING_ID = "internalProperty_mappingId";
        public static final String RBAC_ACCESS_POLICY = "internalProperty_rbac_access_policy";
        public static final String HEADER_MODIFICATION_TO_ADD = "internalProperty_headerModificationToAdd";
        public static final String HEADER_MODIFICATION_TO_REMOVE = "internalProperty_headerModificationToRemove";
        public static final String SESSION_FAILED = "internalProperty_sessionFailed";
        public static final String SERVLET_REQUEST_URL = "internalProperty_servletRequestUrl";
        public static final String CONTEXT_INIT_MARKERS = "internalProperty_contextInitMarkers";
        public static final String OVERRIDE_CONTEXT_PARAMS = "internalProperty_overrideContextParams";
        public static final String ENABLE_AUTH_RESTORE_PROP = "internalProperty_enableAuthRestore";
        public static final String DEPLOYMENT_RUNTIME_PROPERTIES_MAP_PROP = "internalProperty_deploymentRuntimePropertiesMap";
        public static final String ABAC_RESOURCE_PROP = "internalProperty_abacResource";
        public static final String ACKNOWLEDGE_MODE_PROP = "internalProperty_acknowledgeMode";
        public static final String PRESERVED_AUTH_PROP = "internalProperty_preservedAuth";
        public static final String INTERRUPT_EXCHANGE_HTTP_CODE_PROP = "internalProperty_interruptExchangeHttpCode";
        public static final String REJECT_REQUEST_IF_NULL_BODY_GET_DELETE_PROP = "internalProperty_rejectRequestIfNonNullBodyGetDelete";
        public static final String ALLOWED_CONTENT_TYPES_PROP = "internalProperty_allowedContentTypes";
        public static final String SDS_EXECUTION_ID_PROP = "internalProperty_sdsExecutionId";
        public static final String SESSION_ACTIVE_THREAD_COUNTER = "internalProperty_sessionActiveThreadCounter";
        public static final String THREAD_SESSION_STATUSES = "internalProperty_threadSessionStatuses";
        public static final String RESPONSE_FILTER = "internalProperty_responseFilter";
        public static final String RESPONSE_FILTER_EXCLUDE_FIELDS = "internalProperty_responseFilterExclude";
        public static final String RESPONSE_FILTER_INCLUDE_FIELDS = "internalProperty_responseFilterInclude";
        public static final String HTTP_TRIGGER_CHAIN_FAILED = "internalProperty_httpThreadFailed";
        public static final String HTTP_TRIGGER_EXTERNAL_ERROR_CODE = "internalProperty_httpTriggerErrorCode";
        public static final String CORRELATION_ID_POSITION = "correlationIdPosition";
        public static final String CORRELATION_ID_NAME = "correlationIdName";
        public static final String IS_CHECKPOINT_TRIGGER_STEP = "internalProperty_isCheckpointTriggerStep";
        public static final String CHAIN_TIMED_OUT = "internalProperty_chainSessionTimedOut";
        public static final String CHAIN_TIME_OUT_AFTER = "internalProperty_chainSessionTimeoutAfter";
        public static final String HTTP_TRIGGER_STEP_ID = "httpTriggerStepId";
        public static final String SERVICE_CALL_RETRY_COUNT = "retryCount";
        public static final String SERVICE_CALL_RETRY_DELAY = "retryDelay";
        public static final int SERVICE_CALL_DEFAULT_RETRY_DELAY = 5000;
        public static final String SYSTEM_PROPERTY_BLUEGREEN_STATE = "systemProperty_bluegreenState";

        private Properties() {
        }
    }

    public static final class Headers {
        public static final String CAMEL_HTTP_RESPONSE_CODE = "CamelHttpResponseCode";
        public static final String URI_TEMPLATE = "CamelServletContextPath";
        public static final String TRACE_ME = "TraceMe";
        public static final String ORIGINATING_BUSINESS_ID = "originating-bi-id";
        public static final String EXTERNAL_SESSION_CIP_ID = "external-session-cip-id";
        public static final String GQL_VARIABLES_HEADER = "CamelGraphQLVariables";
        public static final String GQL_QUERY_HEADER = "CamelGraphQLQuery";
        public static final String SCHEDULER = "scheduler";
        public static final String JOB_DETAIL = "jobDetail";
        public static final String TRIGGER = "trigger";
        public static final String JOB_INSTANCE = "jobInstance";
        public static final String HTTP_URI = "CamelHttpUri";

        private Headers() {
        }
    }

    public static final class ChainProperties {
        public static final String CHAIN_ID = "chainId";
        public static final String CHAIN_NAME = "chainName";
        public static final String SNAPSHOT_NAME = "snapshotName";
        public static final String ELEMENT_NAME = "elementName";
        public static final String ELEMENT_TYPE = "elementType";
        public static final String ELEMENT_ID = "elementId";
        public static final String PARENT_ELEMENT_ID = "parentElementId";
        public static final String PARENT_ELEMENT_ORIGINAL_ID = "parentElementOriginalId";
        public static final String PARENT_ELEMENT_NAME = "parentElementName";
        public static final String ACTUAL_ELEMENT_CHAIN_ID = "actualElementChainId";
        public static final String ACTUAL_CHAIN_OVERRIDE_STEP_NAME_FIELD = "actualElementChainIdOverrideForStep";
        public static final String HAS_INTERMEDIATE_PARENTS = "hasIntermediateParents";
        public static final String REUSE_ORIGINAL_ID = "reuseOriginalId";
        public static final String CONTAINS_CHECKPOINT_ELEMENTS = "containsCheckpointElements";
        public static final String WIRE_TAP_ID = "wireTapId";
        public static final String EXECUTION_STATUS = "executionStatus";
        public static final String OPERATION_SPECIFICATION_ID = "integrationSpecificationId";
        public static final String OPERATION_PROTOCOL_TYPE_PROP = "integrationOperationProtocolType";
        public static final String OPERATION_PROTOCOL_TYPE_KAFKA = "kafka";
        public static final String OPERATION_PROTOCOL_TYPE_AMQP = "amqp";
        public static final String OPERATION_PROTOCOL_TYPE_HTTP = "http";
        public static final String OPERATION_PROTOCOL_TYPE_GRAPHQL = "graphql";
        public static final String OPERATION_PROTOCOL_TYPE_GRPC = "grpc";
        public static final String OPERATION_PATH_TOPIC = "integrationOperationPath";
        public static final String OPERATION_PATH_EXCHANGE = "integrationOperationPath";
        public static final String OPERATION_PATH = "integrationOperationPath";
        public static final String JMS_INITIAL_CONTEXT_FACTORY = "initialContextFactory";
        public static final String JMS_PROVIDER_URL = "providerUrl";
        public static final String JMS_CONNECTION_FACTORY_NAME = "connectionFactoryName";
        public static final String JMS_USERNAME = "username";
        public static final String JMS_PASSWORD = "password";
        public static final String JMS_DESTINATION_TYPE = "destinationType";
        public static final String JMS_DESTINATION_NAME = "destinationName";
        public static final String SDS_JOB_ID = "jobId";
        public static final String SDS_CRON_EXPRESSION = "cron";
        public static final String SDS_FEATURE_PROHIBIT_PARALLEL_RUN = "prohibitParallelRun";
        public static final String SDS_PARALLEL_RUN_TIMEOUT = "parallelRunTimeout";
        public static final String SERVICE_CALL_ELEMENT = "service-call";
        public static final String REUSE_ESTABLISHED_CONN = "reuseEstablishedConnection";
        public static final String FAILED_ELEMENT_NAME = "failed-element-name";
        public static final String FAILED_ELEMENT_ID = "failed-element-id";
        public static final String EXCEPTION_EXTRA_SESSION_ID = "sessionId";
        public static final String EXCEPTION_EXTRA_FAILED_ELEMENT = "failedElementId";
        public static final String EXCEPTION_EXTRA_VALIDATION_RESULT = "validationResult";
        public static final String EXTERNAL_SERVICE_NAME = "externalServiceName";
        public static final String EXTERNAL_SERVICE_NAME_PROP = "external-service-name";
        public static final String EXTERNAL_SERVICE_ENV_NAME = "externalServiceEnvName";
        public static final String EXTERNAL_SERVICE_ENV_NAME_PROP = "external-service-environment-name";
        public static final String IDEMPOTENCY_ENABLED = "idempotencyEnabled";
        public static final String EXPIRY = "expiry";
        public static final String PATH = "path";
        public static final String METHOD = "method";

        private ChainProperties() {
        }
    }
}

