/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.persistence.shared.repository;

import org.qubership.integration.platform.engine.persistence.shared.entity.IdempotencyRecord;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;

public interface IdempotencyRecordRepository
extends JpaRepository<IdempotencyRecord, String> {
    @Query(nativeQuery=true, value="    select\n        count(r) > 0\n    from\n        engine.idempotency_records r\n    where\n        r.key = :key\n        and r.expires_at >= now()\n")
    public boolean existsByKeyAndNotExpired(String var1);

    @Modifying
    @Query(nativeQuery=true, value="    insert into\n        engine.idempotency_records as r\n            (key, data, created_at, expires_at)\n    values (\n        :key,\n        :data ::json,\n        now(),\n        now() + make_interval(secs => :ttl)\n    )\n    on conflict (key) do update\n        set\n            data = :data ::json,\n            created_at = now(),\n            expires_at = now() + make_interval(secs => :ttl)\n        where\n            r.expires_at < now()\n")
    public int insertIfNotExistsOrUpdateIfExpired(String var1, String var2, int var3);

    @Modifying
    @Query(nativeQuery=true, value="    delete from engine.idempotency_records r where r.expires_at < now()\n")
    public void deleteExpired();

    @Modifying
    @Query(nativeQuery=true, value="    delete from\n        engine.idempotency_records r\n    where\n        r.key = :key\n        and r.expires_at >= now()\n")
    public int deleteByKeyAndNotExpired(String var1);
}

