/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.rest.v1.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import org.qubership.integration.platform.engine.model.logging.SessionsLoggingLevel;

@Schema(description="Information about Live exchange")
public class LiveExchangeDTO {
    @Schema(description="Exchange id")
    private String exchangeId;
    @Schema(description="Deployment id")
    private String deploymentId;
    @Schema(description="Session id")
    private String sessionId;
    @Schema(description="Chain id")
    protected String chainId;
    @Schema(description="Duration of current exchange, in ms")
    private Long duration;
    @Schema(description="Duration of the whole session exchange participates in, in ms")
    private Long sessionDuration;
    @Schema(description="Session start timestamp")
    private Long sessionStartTime;
    @Schema(description="Current session log level")
    private SessionsLoggingLevel sessionLogLevel;
    @Schema(description="Is current exchange main (initial)")
    private Boolean main;

    LiveExchangeDTO(String exchangeId, String deploymentId, String sessionId, String chainId, Long duration, Long sessionDuration, Long sessionStartTime, SessionsLoggingLevel sessionLogLevel, Boolean main) {
        this.exchangeId = exchangeId;
        this.deploymentId = deploymentId;
        this.sessionId = sessionId;
        this.chainId = chainId;
        this.duration = duration;
        this.sessionDuration = sessionDuration;
        this.sessionStartTime = sessionStartTime;
        this.sessionLogLevel = sessionLogLevel;
        this.main = main;
    }

    public static LiveExchangeDTOBuilder builder() {
        return new LiveExchangeDTOBuilder();
    }

    public String getExchangeId() {
        return this.exchangeId;
    }

    public String getDeploymentId() {
        return this.deploymentId;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public String getChainId() {
        return this.chainId;
    }

    public Long getDuration() {
        return this.duration;
    }

    public Long getSessionDuration() {
        return this.sessionDuration;
    }

    public Long getSessionStartTime() {
        return this.sessionStartTime;
    }

    public SessionsLoggingLevel getSessionLogLevel() {
        return this.sessionLogLevel;
    }

    public Boolean getMain() {
        return this.main;
    }

    public void setExchangeId(String exchangeId) {
        this.exchangeId = exchangeId;
    }

    public void setDeploymentId(String deploymentId) {
        this.deploymentId = deploymentId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public void setChainId(String chainId) {
        this.chainId = chainId;
    }

    public void setDuration(Long duration) {
        this.duration = duration;
    }

    public void setSessionDuration(Long sessionDuration) {
        this.sessionDuration = sessionDuration;
    }

    public void setSessionStartTime(Long sessionStartTime) {
        this.sessionStartTime = sessionStartTime;
    }

    public void setSessionLogLevel(SessionsLoggingLevel sessionLogLevel) {
        this.sessionLogLevel = sessionLogLevel;
    }

    public void setMain(Boolean main) {
        this.main = main;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LiveExchangeDTO)) {
            return false;
        }
        LiveExchangeDTO other = (LiveExchangeDTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$duration = this.getDuration();
        Long other$duration = other.getDuration();
        if (this$duration == null ? other$duration != null : !((Object)this$duration).equals(other$duration)) {
            return false;
        }
        Long this$sessionDuration = this.getSessionDuration();
        Long other$sessionDuration = other.getSessionDuration();
        if (this$sessionDuration == null ? other$sessionDuration != null : !((Object)this$sessionDuration).equals(other$sessionDuration)) {
            return false;
        }
        Long this$sessionStartTime = this.getSessionStartTime();
        Long other$sessionStartTime = other.getSessionStartTime();
        if (this$sessionStartTime == null ? other$sessionStartTime != null : !((Object)this$sessionStartTime).equals(other$sessionStartTime)) {
            return false;
        }
        Boolean this$main = this.getMain();
        Boolean other$main = other.getMain();
        if (this$main == null ? other$main != null : !((Object)this$main).equals(other$main)) {
            return false;
        }
        String this$exchangeId = this.getExchangeId();
        String other$exchangeId = other.getExchangeId();
        if (this$exchangeId == null ? other$exchangeId != null : !this$exchangeId.equals(other$exchangeId)) {
            return false;
        }
        String this$deploymentId = this.getDeploymentId();
        String other$deploymentId = other.getDeploymentId();
        if (this$deploymentId == null ? other$deploymentId != null : !this$deploymentId.equals(other$deploymentId)) {
            return false;
        }
        String this$sessionId = this.getSessionId();
        String other$sessionId = other.getSessionId();
        if (this$sessionId == null ? other$sessionId != null : !this$sessionId.equals(other$sessionId)) {
            return false;
        }
        String this$chainId = this.getChainId();
        String other$chainId = other.getChainId();
        if (this$chainId == null ? other$chainId != null : !this$chainId.equals(other$chainId)) {
            return false;
        }
        SessionsLoggingLevel this$sessionLogLevel = this.getSessionLogLevel();
        SessionsLoggingLevel other$sessionLogLevel = other.getSessionLogLevel();
        return !(this$sessionLogLevel == null ? other$sessionLogLevel != null : !((Object)((Object)this$sessionLogLevel)).equals((Object)other$sessionLogLevel));
    }

    protected boolean canEqual(Object other) {
        return other instanceof LiveExchangeDTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $duration = this.getDuration();
        result = result * 59 + ($duration == null ? 43 : ((Object)$duration).hashCode());
        Long $sessionDuration = this.getSessionDuration();
        result = result * 59 + ($sessionDuration == null ? 43 : ((Object)$sessionDuration).hashCode());
        Long $sessionStartTime = this.getSessionStartTime();
        result = result * 59 + ($sessionStartTime == null ? 43 : ((Object)$sessionStartTime).hashCode());
        Boolean $main = this.getMain();
        result = result * 59 + ($main == null ? 43 : ((Object)$main).hashCode());
        String $exchangeId = this.getExchangeId();
        result = result * 59 + ($exchangeId == null ? 43 : $exchangeId.hashCode());
        String $deploymentId = this.getDeploymentId();
        result = result * 59 + ($deploymentId == null ? 43 : $deploymentId.hashCode());
        String $sessionId = this.getSessionId();
        result = result * 59 + ($sessionId == null ? 43 : $sessionId.hashCode());
        String $chainId = this.getChainId();
        result = result * 59 + ($chainId == null ? 43 : $chainId.hashCode());
        SessionsLoggingLevel $sessionLogLevel = this.getSessionLogLevel();
        result = result * 59 + ($sessionLogLevel == null ? 43 : ((Object)((Object)$sessionLogLevel)).hashCode());
        return result;
    }

    public String toString() {
        return "LiveExchangeDTO(exchangeId=" + this.getExchangeId() + ", deploymentId=" + this.getDeploymentId() + ", sessionId=" + this.getSessionId() + ", chainId=" + this.getChainId() + ", duration=" + this.getDuration() + ", sessionDuration=" + this.getSessionDuration() + ", sessionStartTime=" + this.getSessionStartTime() + ", sessionLogLevel=" + String.valueOf((Object)this.getSessionLogLevel()) + ", main=" + this.getMain() + ")";
    }

    public static class LiveExchangeDTOBuilder {
        private String exchangeId;
        private String deploymentId;
        private String sessionId;
        private String chainId;
        private Long duration;
        private Long sessionDuration;
        private Long sessionStartTime;
        private SessionsLoggingLevel sessionLogLevel;
        private Boolean main;

        LiveExchangeDTOBuilder() {
        }

        public LiveExchangeDTOBuilder exchangeId(String exchangeId) {
            this.exchangeId = exchangeId;
            return this;
        }

        public LiveExchangeDTOBuilder deploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
            return this;
        }

        public LiveExchangeDTOBuilder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public LiveExchangeDTOBuilder chainId(String chainId) {
            this.chainId = chainId;
            return this;
        }

        public LiveExchangeDTOBuilder duration(Long duration) {
            this.duration = duration;
            return this;
        }

        public LiveExchangeDTOBuilder sessionDuration(Long sessionDuration) {
            this.sessionDuration = sessionDuration;
            return this;
        }

        public LiveExchangeDTOBuilder sessionStartTime(Long sessionStartTime) {
            this.sessionStartTime = sessionStartTime;
            return this;
        }

        public LiveExchangeDTOBuilder sessionLogLevel(SessionsLoggingLevel sessionLogLevel) {
            this.sessionLogLevel = sessionLogLevel;
            return this;
        }

        public LiveExchangeDTOBuilder main(Boolean main) {
            this.main = main;
            return this;
        }

        public LiveExchangeDTO build() {
            return new LiveExchangeDTO(this.exchangeId, this.deploymentId, this.sessionId, this.chainId, this.duration, this.sessionDuration, this.sessionStartTime, this.sessionLogLevel, this.main);
        }

        public String toString() {
            return "LiveExchangeDTO.LiveExchangeDTOBuilder(exchangeId=" + this.exchangeId + ", deploymentId=" + this.deploymentId + ", sessionId=" + this.sessionId + ", chainId=" + this.chainId + ", duration=" + this.duration + ", sessionDuration=" + this.sessionDuration + ", sessionStartTime=" + this.sessionStartTime + ", sessionLogLevel=" + String.valueOf((Object)this.sessionLogLevel) + ", main=" + this.main + ")";
        }
    }
}

