/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.service;

import groovy.lang.GroovyShell;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.camel.CamelContext;
import org.apache.camel.Route;
import org.apache.camel.TypeConverter;
import org.apache.camel.impl.engine.DefaultManagementStrategy;
import org.apache.camel.impl.engine.DefaultStreamCachingStrategy;
import org.apache.camel.model.CircuitBreakerDefinition;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.RouteDefinitionHelper;
import org.apache.camel.model.RoutesDefinition;
import org.apache.camel.model.StepDefinition;
import org.apache.camel.model.language.ExpressionDefinition;
import org.apache.camel.observation.MicrometerObservationTracer;
import org.apache.camel.reifier.ProcessorReifier;
import org.apache.camel.spi.ClassResolver;
import org.apache.camel.spi.Debugger;
import org.apache.camel.spi.ManagementStrategy;
import org.apache.camel.spi.MessageHistoryFactory;
import org.apache.camel.spi.StreamCachingStrategy;
import org.apache.camel.spring.SpringCamelContext;
import org.apache.camel.tracing.Tracer;
import org.apache.camel.xml.jaxb.JaxbHelper;
import org.apache.commons.lang3.tuple.Pair;
import org.codehaus.groovy.control.CompilationFailedException;
import org.jetbrains.annotations.NotNull;
import org.qubership.integration.platform.engine.camel.CustomResilienceReifier;
import org.qubership.integration.platform.engine.camel.QipCustomClassResolver;
import org.qubership.integration.platform.engine.camel.converters.FormDataConverter;
import org.qubership.integration.platform.engine.camel.converters.SecurityAccessPolicyConverter;
import org.qubership.integration.platform.engine.camel.history.FilteringMessageHistoryFactory;
import org.qubership.integration.platform.engine.configuration.ServerConfiguration;
import org.qubership.integration.platform.engine.configuration.TracingConfiguration;
import org.qubership.integration.platform.engine.consul.DeploymentReadinessService;
import org.qubership.integration.platform.engine.consul.EngineStateReporter;
import org.qubership.integration.platform.engine.errorhandling.DeploymentRetriableException;
import org.qubership.integration.platform.engine.errorhandling.errorcode.ErrorCode;
import org.qubership.integration.platform.engine.events.ConsulSessionCreatedEvent;
import org.qubership.integration.platform.engine.forms.FormData;
import org.qubership.integration.platform.engine.model.RuntimeIntegrationCache;
import org.qubership.integration.platform.engine.model.deployment.DeploymentOperation;
import org.qubership.integration.platform.engine.model.deployment.engine.DeploymentStatus;
import org.qubership.integration.platform.engine.model.deployment.engine.EngineDeployment;
import org.qubership.integration.platform.engine.model.deployment.engine.EngineState;
import org.qubership.integration.platform.engine.model.deployment.properties.CamelDebuggerProperties;
import org.qubership.integration.platform.engine.model.deployment.update.DeploymentConfiguration;
import org.qubership.integration.platform.engine.model.deployment.update.DeploymentInfo;
import org.qubership.integration.platform.engine.model.deployment.update.DeploymentRouteUpdate;
import org.qubership.integration.platform.engine.model.deployment.update.DeploymentUpdate;
import org.qubership.integration.platform.engine.model.deployment.update.DeploymentsUpdate;
import org.qubership.integration.platform.engine.model.deployment.update.ElementProperties;
import org.qubership.integration.platform.engine.model.deployment.update.RouteType;
import org.qubership.integration.platform.engine.security.QipSecurityAccessPolicy;
import org.qubership.integration.platform.engine.service.CustomStepReifier;
import org.qubership.integration.platform.engine.service.MaasService;
import org.qubership.integration.platform.engine.service.QuartzSchedulerService;
import org.qubership.integration.platform.engine.service.VariablesService;
import org.qubership.integration.platform.engine.service.debugger.CamelDebugger;
import org.qubership.integration.platform.engine.service.debugger.CamelDebuggerPropertiesService;
import org.qubership.integration.platform.engine.service.debugger.metrics.MetricsStore;
import org.qubership.integration.platform.engine.service.deployment.processing.DeploymentProcessingService;
import org.qubership.integration.platform.engine.service.deployment.processing.actions.context.before.RegisterRoutesInControlPlaneAction;
import org.qubership.integration.platform.engine.service.externallibrary.ExternalLibraryGroovyShellFactory;
import org.qubership.integration.platform.engine.service.externallibrary.ExternalLibraryService;
import org.qubership.integration.platform.engine.service.externallibrary.GroovyLanguageWithResettableCache;
import org.qubership.integration.platform.engine.service.xmlpreprocessor.XmlConfigurationPreProcessor;
import org.qubership.integration.platform.engine.util.MDCUtil;
import org.qubership.integration.platform.engine.util.log.ExtendedErrorLogger;
import org.qubership.integration.platform.engine.util.log.ExtendedErrorLoggerFactory;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.event.EventListener;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class IntegrationRuntimeService
implements ApplicationContextAware {
    private static final ExtendedErrorLogger log = ExtendedErrorLoggerFactory.getLogger(IntegrationRuntimeService.class);
    private final ServerConfiguration serverConfiguration;
    private final QuartzSchedulerService quartzSchedulerService;
    private final TracingConfiguration tracingConfiguration;
    private final ExternalLibraryGroovyShellFactory groovyShellFactory;
    private final GroovyLanguageWithResettableCache groovyLanguage;
    private final MetricsStore metricsStore;
    private final Optional<ExternalLibraryService> externalLibraryService;
    private final Optional<MaasService> maasService;
    private final Optional<XmlConfigurationPreProcessor> xmlPreProcessor;
    private final VariablesService variablesService;
    private final EngineStateReporter engineStateReporter;
    private final CamelDebuggerPropertiesService propertiesService;
    private final DeploymentReadinessService deploymentReadinessService;
    private final FormDataConverter formDataConverter;
    private final SecurityAccessPolicyConverter securityAccessPolicyConverter;
    private final Predicate<FilteringMessageHistoryFactory.FilteringEntity> camelMessageHistoryFilter;
    private final RuntimeIntegrationCache deploymentCache = new RuntimeIntegrationCache();
    private final ReadWriteLock processLock = new ReentrantReadWriteLock();
    private final DeploymentProcessingService deploymentProcessingService;
    private final Executor deploymentExecutor;
    private final ObjectFactory<CamelDebugger> camelDebuggerFactory;
    private final ObjectFactory<MicrometerObservationTracer> tracerFactory;
    private ApplicationContext applicationContext;
    @Value(value="${qip.camel.stream-caching.enabled}")
    private boolean enableStreamCaching;
    private final int streamCachingBufferSize;

    @Autowired
    public IntegrationRuntimeService(ServerConfiguration serverConfiguration, QuartzSchedulerService quartzSchedulerService, TracingConfiguration tracingConfiguration, ExternalLibraryGroovyShellFactory groovyShellFactory, GroovyLanguageWithResettableCache groovyLanguage, MetricsStore metricsStore, Optional<ExternalLibraryService> externalLibraryService, Optional<MaasService> maasService, Optional<XmlConfigurationPreProcessor> xmlPreProcessor, VariablesService variablesService, EngineStateReporter engineStateReporter, @Qualifier(value="deploymentExecutor") Executor deploymentExecutor, CamelDebuggerPropertiesService propertiesService, @Value(value="${qip.camel.stream-caching.buffer.size-kb}") int streamCachingBufferSizeKb, Predicate<FilteringMessageHistoryFactory.FilteringEntity> camelMessageHistoryFilter, DeploymentReadinessService deploymentReadinessService, DeploymentProcessingService deploymentProcessingService, FormDataConverter formDataConverter, SecurityAccessPolicyConverter securityAccessPolicyConverter, ObjectFactory<CamelDebugger> camelDebuggerFactory, @Qualifier(value="camelObservationTracer") ObjectFactory<MicrometerObservationTracer> tracerFactory) {
        this.serverConfiguration = serverConfiguration;
        this.quartzSchedulerService = quartzSchedulerService;
        this.tracingConfiguration = tracingConfiguration;
        this.groovyShellFactory = groovyShellFactory;
        this.groovyLanguage = groovyLanguage;
        this.metricsStore = metricsStore;
        this.externalLibraryService = externalLibraryService;
        this.maasService = maasService;
        this.xmlPreProcessor = xmlPreProcessor;
        this.variablesService = variablesService;
        this.engineStateReporter = engineStateReporter;
        this.deploymentExecutor = deploymentExecutor;
        this.propertiesService = propertiesService;
        this.streamCachingBufferSize = streamCachingBufferSizeKb * 1024;
        this.camelMessageHistoryFilter = camelMessageHistoryFilter;
        this.deploymentReadinessService = deploymentReadinessService;
        this.deploymentProcessingService = deploymentProcessingService;
        this.formDataConverter = formDataConverter;
        this.securityAccessPolicyConverter = securityAccessPolicyConverter;
        this.camelDebuggerFactory = camelDebuggerFactory;
        this.tracerFactory = tracerFactory;
    }

    public void setApplicationContext(@NotNull ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    @Async
    @EventListener
    public void onExternalLibrariesUpdated(ConsulSessionCreatedEvent event) {
        this.updateEngineState();
    }

    public List<DeploymentInfo> buildExcludeDeploymentsMap() {
        Lock processLock = this.processLock.writeLock();
        try {
            processLock.lock();
            List<DeploymentInfo> list = this.deploymentCache.getDeployments().values().stream().map(EngineDeployment::getDeploymentInfo).toList();
            return list;
        }
        finally {
            processLock.unlock();
        }
    }

    private Map<String, EngineDeployment> buildActualDeploymentsSnapshot() {
        Lock processLock = this.processLock.writeLock();
        try {
            processLock.lock();
            Map<String, EngineDeployment> map = this.deploymentCache.getDeployments().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((EngineDeployment)entry.getValue()).toBuilder().build()));
            return map;
        }
        finally {
            processLock.unlock();
        }
    }

    public void processAndUpdateState(DeploymentsUpdate update, boolean retry) throws ExecutionException, InterruptedException {
        TreeSet chainDeployments;
        ArrayList completableFutures = new ArrayList();
        HashMap<String, TreeSet> updatesPerChain = new HashMap<String, TreeSet>();
        for (DeploymentUpdate deploymentUpdate : update.getUpdate()) {
            chainDeployments = updatesPerChain.computeIfAbsent(deploymentUpdate.getDeploymentInfo().getChainId(), k -> new TreeSet<DeploymentUpdate>(Comparator.comparingLong(d -> d.getDeploymentInfo().getCreatedWhen())));
            chainDeployments.add(deploymentUpdate);
        }
        for (Map.Entry entry : updatesPerChain.entrySet()) {
            chainDeployments = (TreeSet)entry.getValue();
            completableFutures.add(this.process(chainDeployments, DeploymentOperation.UPDATE, retry));
        }
        for (DeploymentUpdate deploymentUpdate : update.getStop()) {
            completableFutures.add(this.process(Collections.singletonList(deploymentUpdate), DeploymentOperation.STOP, retry));
        }
        CompletableFuture.allOf(completableFutures.toArray(new CompletableFuture[0])).get();
        this.updateEngineState();
    }

    private synchronized void updateEngineState() {
        this.engineStateReporter.addStateToQueue(EngineState.builder().engine(this.serverConfiguration.getEngineInfo()).deployments(this.buildActualDeploymentsSnapshot()).build());
    }

    private CompletableFuture<?> process(Collection<DeploymentUpdate> chainDeployments, DeploymentOperation operation, boolean retry) {
        return CompletableFuture.runAsync(() -> {
            MDCUtil.setRequestId(UUID.randomUUID().toString());
            for (DeploymentUpdate chainDeployment : chainDeployments) {
                block7: {
                    log.info("Start processing deployment {}, operation: {}", (Object)chainDeployment.getDeploymentInfo(), (Object)operation);
                    Lock chainLock = this.getCache().getLockForChain(chainDeployment.getDeploymentInfo().getChainId());
                    try {
                        chainLock.lock();
                        log.debug("Locked by-chain lock");
                        if (retry && !this.getCache().getDeployments().containsKey(chainDeployment.getDeploymentInfo().getDeploymentId())) break block7;
                        Lock processWeakLock = this.processLock.readLock();
                        try {
                            processWeakLock.lock();
                            log.debug("Locked process read lock");
                            this.processDeploymentUpdate(chainDeployment, operation);
                        }
                        finally {
                            processWeakLock.unlock();
                            log.debug("Unlocked process read lock");
                        }
                    }
                    finally {
                        chainLock.unlock();
                        log.debug("Unlocked by-chain lock");
                    }
                }
                log.info("Deployment {} processing completed", (Object)chainDeployment.getDeploymentInfo().getDeploymentId());
            }
        }, this.deploymentExecutor);
    }

    /*
     * Exception decompiling
     */
    private void processDeploymentUpdate(DeploymentUpdate deployment, DeploymentOperation operation) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean isDeploymentsSuspended() {
        return !this.deploymentReadinessService.isInitialized();
    }

    private DeploymentStatus processDeployment(DeploymentUpdate deployment, DeploymentOperation operation) throws Exception {
        return switch (operation) {
            default -> throw new MatchException(null, null);
            case DeploymentOperation.UPDATE -> this.update(deployment);
            case DeploymentOperation.STOP -> this.stop(deployment.getDeploymentInfo());
        };
    }

    private DeploymentStatus update(DeploymentUpdate deployment) throws Exception {
        DeploymentInfo deploymentInfo = deployment.getDeploymentInfo();
        String deploymentId = deploymentInfo.getDeploymentId();
        DeploymentConfiguration configuration = deployment.getConfiguration();
        String configurationXml = this.preprocessDeploymentConfigurationXml(configuration);
        this.deploymentProcessingService.processBeforeContextCreated(deploymentInfo, configuration);
        this.propertiesService.mergeWithRuntimeProperties(CamelDebuggerProperties.builder().deploymentInfo(deployment.getDeploymentInfo()).maskedFields(deployment.getMaskedFields()).properties(configuration.getProperties()).build());
        SpringCamelContext context = (SpringCamelContext)this.getCache().getContexts().get(deploymentId);
        if (context != null && log.isDebugEnabled()) {
            log.debug("Context for deployment {} already exists", (Object)deploymentId);
        }
        if (log.isDebugEnabled()) {
            log.debug("Creating context for deployment {}", (Object)deploymentId);
        }
        context = this.buildContext(deploymentInfo, configuration, configurationXml);
        this.getCache().getContexts().put(deploymentId, context);
        List<Pair<DeploymentInfo, SpringCamelContext>> contextsToStop = this.getContextsRelatedToDeployment(deployment, state -> !state.getDeploymentInfo().getDeploymentId().equals(deployment.getDeploymentInfo().getDeploymentId()));
        try {
            this.startContext(context);
        }
        catch (Exception e) {
            this.quartzSchedulerService.commitScheduledJobs();
            this.deploymentProcessingService.processStopContext(context, deploymentInfo, configuration);
            throw e;
        }
        contextsToStop.stream().forEach(p -> this.stopDeploymentContext((SpringCamelContext)p.getRight(), (DeploymentInfo)p.getLeft()));
        this.quartzSchedulerService.commitScheduledJobs();
        if (log.isDebugEnabled()) {
            log.debug("Context for deployment {} has started", (Object)deploymentId);
        }
        return DeploymentStatus.DEPLOYED;
    }

    private String preprocessDeploymentConfigurationXml(DeploymentConfiguration configuration) throws URISyntaxException {
        String configurationXml = configuration.getXml();
        configurationXml = this.variablesService.injectVariables(configurationXml, true);
        if (this.maasService.isPresent()) {
            configurationXml = this.maasService.get().resolveDeploymentMaasParameters(configuration, configurationXml);
        }
        configurationXml = this.resolveRouteVariables(configuration.getRoutes(), configurationXml);
        if (this.xmlPreProcessor.isPresent()) {
            configurationXml = this.xmlPreProcessor.get().process(configurationXml);
        }
        return configurationXml;
    }

    private String resolveRouteVariables(List<DeploymentRouteUpdate> routes, String text) {
        String result = text;
        for (DeploymentRouteUpdate route : routes) {
            DeploymentRouteUpdate tempRoute = RegisterRoutesInControlPlaneAction.formatServiceRoutes(route);
            RouteType type = tempRoute.getType();
            if (!Objects.nonNull(tempRoute.getVariableName()) || RouteType.EXTERNAL_SENDER != type && RouteType.EXTERNAL_SERVICE != type) continue;
            String variablePlaceholder = String.format("%%%%{%s}", tempRoute.getVariableName());
            String gatewayPrefix = tempRoute.getGatewayPrefix();
            result = result.replace(variablePlaceholder, Objects.isNull(gatewayPrefix) ? "" : gatewayPrefix);
        }
        return result;
    }

    private void removeOldDeployments(DeploymentUpdate deployment, Predicate<DeploymentStatus> statusPredicate) {
        Iterator iterator = this.getCache().getDeployments().entrySet().iterator();
        ArrayList<Pair> contextsToRemove = new ArrayList<Pair>();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            DeploymentInfo depInfo = ((EngineDeployment)entry.getValue()).getDeploymentInfo();
            if (!depInfo.getChainId().equals(deployment.getDeploymentInfo().getChainId()) || !statusPredicate.test(((EngineDeployment)entry.getValue()).getStatus()) || depInfo.getDeploymentId().equals(deployment.getDeploymentInfo().getDeploymentId())) continue;
            SpringCamelContext toRemoveContext = (SpringCamelContext)this.getCache().getContexts().remove(entry.getKey());
            if (toRemoveContext != null) {
                contextsToRemove.add(Pair.of((Object)depInfo, (Object)toRemoveContext));
            }
            this.removeRetryingDeployment(depInfo.getDeploymentId());
            this.metricsStore.removeChainsDeployments(depInfo.getDeploymentId());
            iterator.remove();
            this.propertiesService.removeDeployProperties((String)entry.getKey());
        }
        contextsToRemove.stream().filter(p -> ((SpringCamelContext)p.getRight()).isRunning()).forEach(p -> this.stopDeploymentContext((SpringCamelContext)p.getRight(), (DeploymentInfo)p.getLeft()));
    }

    private List<Pair<DeploymentInfo, SpringCamelContext>> getContextsRelatedToDeployment(DeploymentUpdate deployment, Predicate<EngineDeployment> filter) {
        return this.getCache().getDeployments().entrySet().stream().filter(entry -> ((EngineDeployment)entry.getValue()).getDeploymentInfo().getChainId().equals(deployment.getDeploymentInfo().getChainId()) && filter.test((EngineDeployment)entry.getValue())).map(entry -> Pair.of((Object)((EngineDeployment)entry.getValue()).getDeploymentInfo(), (Object)((SpringCamelContext)this.getCache().getContexts().get(entry.getKey())))).toList();
    }

    private SpringCamelContext buildContext(DeploymentInfo deploymentInfo, DeploymentConfiguration deploymentConfiguration, String configurationXml) throws Exception {
        SpringCamelContext context = new SpringCamelContext(this.applicationContext);
        context.getTypeConverterRegistry().addTypeConverter(FormData.class, String.class, (TypeConverter)this.formDataConverter);
        context.getTypeConverterRegistry().addTypeConverter(QipSecurityAccessPolicy.class, String.class, (TypeConverter)this.securityAccessPolicyConverter);
        context.getGlobalOptions().put("CamelJacksonEnableTypeConverter", "true");
        context.getGlobalOptions().put("CamelJacksonTypeConverterToPojo", "true");
        context.getInflightRepository().setInflightBrowseEnabled(true);
        boolean deploymentsSuspended = this.isDeploymentsSuspended();
        if (deploymentsSuspended) {
            context.setAutoStartup(Boolean.valueOf(false));
            log.debug("Deployment {} will be suspended due to pod initialization", (Object)deploymentInfo.getDeploymentId());
        }
        context.setClassResolver(this.getClassResolver(context, deploymentConfiguration));
        context.setApplicationContext(this.applicationContext);
        String deploymentId = deploymentInfo.getDeploymentId();
        context.setManagementName("camel-context_" + deploymentId);
        context.setManagementStrategy((ManagementStrategy)new DefaultManagementStrategy((CamelContext)context));
        CamelDebugger debugger = (CamelDebugger)((Object)this.camelDebuggerFactory.getObject());
        debugger.setDeploymentId(deploymentId);
        context.setDebugger((Debugger)debugger);
        context.setDebugging(Boolean.valueOf(true));
        this.configureMessageHistoryFactory(context);
        context.setStreamCaching(Boolean.valueOf(this.enableStreamCaching));
        if (this.enableStreamCaching) {
            DefaultStreamCachingStrategy streamCachingStrategy = new DefaultStreamCachingStrategy();
            streamCachingStrategy.setBufferSize(this.streamCachingBufferSize);
            context.setStreamCachingStrategy((StreamCachingStrategy)streamCachingStrategy);
        }
        this.deploymentProcessingService.processAfterContextCreated(context, deploymentInfo, deploymentConfiguration);
        this.loadRoutes(context, configurationXml);
        return context;
    }

    private ClassResolver getClassResolver(SpringCamelContext context, DeploymentConfiguration deploymentConfiguration) {
        List<String> systemModelIds = deploymentConfiguration.getProperties().stream().map(ElementProperties::getProperties).filter(properties -> "service-call".equals(properties.get("elementType"))).map(properties -> (String)properties.get("integrationSpecificationId")).filter(Objects::nonNull).toList();
        ClassLoader classLoader = this.externalLibraryService.isPresent() ? this.externalLibraryService.get().getClassLoaderForSystemModels(systemModelIds, context.getApplicationContextClassLoader()) : this.getClass().getClassLoader();
        return new QipCustomClassResolver(classLoader);
    }

    private void startContext(SpringCamelContext context) {
        if (this.tracingConfiguration.isTracingEnabled()) {
            Tracer tracer = (Tracer)this.tracerFactory.getObject();
            tracer.init((CamelContext)context);
        }
        context.start();
    }

    private void configureMessageHistoryFactory(SpringCamelContext context) {
        context.setMessageHistory(Boolean.valueOf(true));
        MessageHistoryFactory defaultFactory = context.getMessageHistoryFactory();
        FilteringMessageHistoryFactory factory = new FilteringMessageHistoryFactory(this.camelMessageHistoryFilter, defaultFactory);
        context.setMessageHistoryFactory((MessageHistoryFactory)factory);
    }

    private void loadRoutes(SpringCamelContext context, String xmlConfiguration) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug("Loading routes from: \n{}", (Object)xmlConfiguration);
        }
        byte[] configurationBytes = xmlConfiguration.getBytes();
        ByteArrayInputStream configInputStream = new ByteArrayInputStream(configurationBytes);
        RoutesDefinition routesDefinition = JaxbHelper.loadRoutesDefinition((CamelContext)context, (InputStream)configInputStream);
        for (RouteDefinition route : routesDefinition.getRoutes()) {
            RouteDefinitionHelper.prepareRoute((CamelContext)context, (RouteDefinition)route);
            route.markPrepared();
        }
        routesDefinition.getRoutes().forEach(RouteDefinition::markUnprepared);
        this.compileGroovyScripts(routesDefinition);
        context.addRouteDefinitions((Collection)routesDefinition.getRoutes());
    }

    private void compileGroovyScripts(RoutesDefinition routesDefinition) {
        for (RouteDefinition route : routesDefinition.getRoutes()) {
            for (ProcessorDefinition processor : route.getOutputs()) {
                ExpressionDefinition expression;
                if (!(processor instanceof ExpressionNode) || !(expression = ((ExpressionNode)processor).getExpression()).getLanguage().equals("groovy")) continue;
                log.debug("Compiling groovy script for processor {}", (Object)processor.getId());
                this.compileGroovyScript(expression);
            }
        }
    }

    private void compileGroovyScript(ExpressionDefinition expression) {
        try {
            String text = expression.getExpression();
            if (Objects.isNull(expression.getTrim()) || Boolean.parseBoolean(expression.getTrim())) {
                text = text.trim();
            }
            GroovyShell groovyShell = this.groovyShellFactory.createGroovyShell(null);
            Class scriptClass = groovyShell.getClassLoader().parseClass(text);
            this.groovyLanguage.addScriptToCache(text, scriptClass);
        }
        catch (CompilationFailedException exception) {
            if (IntegrationRuntimeService.isClassResolveError(exception)) {
                throw new DeploymentRetriableException("Failed to compile groovy script.", (Exception)((Object)exception));
            }
            throw new RuntimeException("Failed to compile groovy script.", exception);
        }
    }

    private static boolean isClassResolveError(CompilationFailedException exception) {
        return exception.getMessage().contains("unable to resolve class");
    }

    private DeploymentStatus stop(DeploymentInfo deploymentInfo) {
        String deploymentId = deploymentInfo.getDeploymentId();
        SpringCamelContext context = (SpringCamelContext)this.getCache().getContexts().remove(deploymentId);
        if (Objects.nonNull(context)) {
            log.debug("Removing context for deployment: {}", (Object)deploymentInfo.getDeploymentId());
        }
        this.stopDeploymentContext(context, deploymentInfo);
        return DeploymentStatus.REMOVED;
    }

    private void stopDeploymentContext(SpringCamelContext context, DeploymentInfo deploymentInfo) {
        this.deploymentProcessingService.processStopContext(context, deploymentInfo, null);
        if (Objects.nonNull(context)) {
            this.quartzSchedulerService.removeSchedulerJobsFromContexts(Collections.singletonList(context));
            if (context.isRunning()) {
                log.debug("Stopping context for deployment: {}", (Object)deploymentInfo.getDeploymentId());
                context.stop();
            }
        }
    }

    public void retryProcessingDeploys() {
        try {
            Collection<DeploymentUpdate> toRetry = this.getCache().flushDeploymentsToRetry();
            if (!toRetry.isEmpty()) {
                this.processAndUpdateState(DeploymentsUpdate.builder().update(toRetry).build(), true);
            }
        }
        catch (Exception e) {
            log.error("Failed to process retry deployments", e);
        }
    }

    private void putInRetryQueue(DeploymentUpdate deploymentUpdate) {
        log.info("Deployment marked for retry {}", (Object)deploymentUpdate.getDeploymentInfo().getDeploymentId());
        this.getCache().putToRetryQueue(deploymentUpdate);
    }

    private void removeRetryingDeployment(String deploymentId) {
        this.getCache().removeRetryDeploymentFromQueue(deploymentId);
    }

    public RuntimeIntegrationCache getCache() {
        return this.deploymentCache;
    }

    public void startAllRoutesOnInit() {
        this.getCache().getContexts().forEach((deploymentId, context) -> {
            EngineDeployment state = (EngineDeployment)this.getCache().getDeployments().get(deploymentId);
            try {
                context.startAllRoutes();
                log.debug("Deployment {} was resumed from suspend", deploymentId);
            }
            catch (Exception e) {
                if (state != null) {
                    state.setStatus(DeploymentStatus.FAILED);
                    state.setErrorMessage("Deployment wasn't initialized correctly during pod startup " + e.getMessage());
                }
                ErrorCode errorCode = ErrorCode.DEPLOYMENT_START_ERROR;
                log.error(errorCode, errorCode.compileMessage((String)deploymentId), (Throwable)e);
            }
            finally {
                if (state != null) {
                    state.setSuspended(false);
                }
            }
        });
    }

    private void runInProcessLock(Runnable callback) {
        Lock lock = this.processLock.writeLock();
        try {
            lock.lock();
            callback.run();
        }
        finally {
            lock.unlock();
        }
    }

    public void suspendAllSchedulers() {
        this.runInProcessLock(this.quartzSchedulerService::suspendAllSchedulers);
    }

    public void resumeAllSchedulers() {
        this.runInProcessLock(this.quartzSchedulerService::resumeAllSchedulers);
    }

    private static /* synthetic */ boolean lambda$processDeploymentUpdate$6(DeploymentStatus deploymentStatus) {
        return deploymentStatus == DeploymentStatus.FAILED || deploymentStatus == DeploymentStatus.PROCESSING;
    }

    private static /* synthetic */ boolean lambda$processDeploymentUpdate$5(DeploymentStatus deploymentStatus) {
        return true;
    }

    static {
        ProcessorReifier.registerReifier(StepDefinition.class, CustomStepReifier::new);
        ProcessorReifier.registerReifier(CircuitBreakerDefinition.class, (route, definition) -> new CustomResilienceReifier((Route)route, (CircuitBreakerDefinition)definition));
    }
}

