/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.service;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Route;
import org.apache.camel.component.file.remote.SftpConsumer;
import org.apache.camel.component.file.remote.SftpEndpoint;
import org.apache.camel.component.quartz.QuartzEndpoint;
import org.apache.camel.pollconsumer.quartz.QuartzScheduledPollConsumerScheduler;
import org.apache.camel.spi.ScheduledPollConsumerScheduler;
import org.apache.camel.spring.SpringCamelContext;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.SchedulerException;
import org.quartz.SchedulerFactory;
import org.quartz.TriggerKey;
import org.qubership.integration.platform.engine.camel.scheduler.StdSchedulerFactoryProxy;
import org.qubership.integration.platform.engine.camel.scheduler.StdSchedulerProxy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class QuartzSchedulerService {
    private static final Logger log = LoggerFactory.getLogger(QuartzSchedulerService.class);
    private final StdSchedulerFactoryProxy schedulerFactoryProxy;

    @Autowired
    public QuartzSchedulerService(StdSchedulerFactoryProxy schedulerFactoryProxy) {
        this.schedulerFactoryProxy = schedulerFactoryProxy;
    }

    public void removeSchedulerJobs(List<JobKey> jobs) {
        try {
            log.debug("Remove camel scheduler jobs: {}", jobs);
            if (!jobs.isEmpty()) {
                this.getFactory().getScheduler().deleteJobs(jobs);
            }
        }
        catch (SchedulerException e) {
            log.error("Failed to delete scheduler jobs", (Throwable)e);
        }
    }

    public void removeSchedulerJobsFromContext(SpringCamelContext context) {
        try {
            this.getFactory().getScheduler().deleteJobs(this.getSchedulerJobsFromContext(context));
        }
        catch (SchedulerException e) {
            log.error("Failed to delete scheduler jobs", (Throwable)e);
        }
    }

    public void removeSchedulerJobsFromContexts(List<SpringCamelContext> contexts) {
        try {
            log.debug("Remove camel scheduler jobs from contexts");
            if (!contexts.isEmpty()) {
                this.getFactory().getScheduler().deleteJobs(this.getSchedulerJobsFromContexts(contexts));
            }
        }
        catch (SchedulerException e) {
            log.error("Failed to delete scheduler jobs", (Throwable)e);
        }
    }

    public List<JobKey> getSchedulerJobsFromContext(SpringCamelContext context) {
        return this.getSchedulerJobsFromContexts(Collections.singletonList(context));
    }

    public List<JobKey> getSchedulerJobsFromContexts(List<SpringCamelContext> contexts) {
        ArrayList<JobKey> jobs = new ArrayList<JobKey>();
        log.debug("Get camel scheduler jobs from contexts");
        for (SpringCamelContext context : contexts) {
            for (Endpoint endpoint : context.getEndpoints()) {
                if (endpoint instanceof QuartzEndpoint) {
                    QuartzEndpoint quartzEndpoint = (QuartzEndpoint)endpoint;
                    TriggerKey triggerKey = quartzEndpoint.getTriggerKey();
                    JobKey jobKey = JobKey.jobKey((String)triggerKey.getName(), (String)triggerKey.getGroup());
                    jobs.add(jobKey);
                    continue;
                }
                if (!(endpoint instanceof SftpEndpoint)) continue;
                for (Route route : context.getRoutes()) {
                    SftpConsumer sftpConsumer;
                    ScheduledPollConsumerScheduler scheduler;
                    Consumer consumer = route.getConsumer();
                    if (!(consumer instanceof SftpConsumer) || !((scheduler = (sftpConsumer = (SftpConsumer)consumer).getScheduler()) instanceof QuartzScheduledPollConsumerScheduler)) continue;
                    QuartzScheduledPollConsumerScheduler quartzScheduler = (QuartzScheduledPollConsumerScheduler)scheduler;
                    try {
                        Field f = quartzScheduler.getClass().getDeclaredField("job");
                        f.setAccessible(true);
                        JobKey jobKey = ((JobDetail)f.get(quartzScheduler)).getKey();
                        jobs.add(jobKey);
                    }
                    catch (Exception e) {
                        log.error("Failed to get field 'job' from class QuartzScheduledPollConsumerScheduler");
                    }
                }
            }
        }
        return jobs;
    }

    public void commitScheduledJobs() {
        try {
            log.debug("Commit camel scheduler jobs");
            ((StdSchedulerProxy)this.getFactory().getScheduler()).commitScheduledJobs();
        }
        catch (SchedulerException e) {
            log.error("Failed to commit scheduled jobs", (Throwable)e);
        }
    }

    public void resetSchedulersProxy() {
        try {
            log.debug("Reset camel scheduler proxy");
            ((StdSchedulerProxy)this.getFactory().getScheduler()).clearDelayedJobs();
        }
        catch (SchedulerException e) {
            log.error("Failed to reset scheduler proxy", (Throwable)e);
        }
    }

    public void suspendAllSchedulers() {
        try {
            log.info("Suspend camel quartz scheduler");
            ((StdSchedulerProxy)this.getFactory()).suspendScheduler();
        }
        catch (Exception e) {
            log.error("Failed to suspend scheduler", (Throwable)e);
        }
    }

    public void resumeAllSchedulers() {
        try {
            log.info("Resume camel quartz scheduler");
            ((StdSchedulerProxy)this.getFactory()).resumeScheduler();
        }
        catch (SchedulerException e) {
            log.error("Failed to resume scheduler", (Throwable)e);
        }
    }

    public SchedulerFactory getFactory() {
        return this.schedulerFactoryProxy;
    }
}

