/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.service.debugger;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.camel.Exchange;
import org.qubership.integration.platform.engine.model.deployment.properties.CamelDebuggerProperties;
import org.qubership.integration.platform.engine.model.deployment.properties.DeploymentRuntimeProperties;
import org.qubership.integration.platform.engine.service.debugger.RuntimePropertiesException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class CamelDebuggerPropertiesService {
    private static final Logger log = LoggerFactory.getLogger(CamelDebuggerPropertiesService.class);
    private final Map<String, AtomicReference<CamelDebuggerProperties>> deployPropertiesCache = new ConcurrentHashMap<String, AtomicReference<CamelDebuggerProperties>>();
    private final AtomicReference<Map<String, DeploymentRuntimeProperties>> runtimePropertiesCacheRef = new AtomicReference(Collections.emptyMap());

    public CamelDebuggerProperties getActualProperties(String deploymentId) {
        return this.getOrCreateDeploymentPair(deploymentId).get();
    }

    private AtomicReference<CamelDebuggerProperties> getOrCreateDeploymentPair(String deploymentId) {
        return this.deployPropertiesCache.computeIfAbsent(deploymentId, k -> new AtomicReference<Object>(null));
    }

    public CamelDebuggerProperties getProperties(Exchange exchange, String deploymentId) {
        CamelDebuggerProperties deployProperties = this.getActualProperties(deploymentId);
        DeploymentRuntimeProperties runtimeProperties = (DeploymentRuntimeProperties)exchange.getProperty("internalProperty_deploymentRuntimePropertiesMap", DeploymentRuntimeProperties.class);
        if (runtimeProperties == null) {
            exchange.setProperty("internalProperty_deploymentRuntimePropertiesMap", (Object)deployProperties.getActualRuntimeProperties());
        }
        return deployProperties;
    }

    public void mergeWithRuntimeProperties(CamelDebuggerProperties deployProperties) throws RuntimePropertiesException {
        String deploymentId = deployProperties.getDeploymentInfo().getDeploymentId();
        this.getOrCreateDeploymentPair(deploymentId).set(deployProperties.toBuilder().runtimePropertiesCacheRef(this.runtimePropertiesCacheRef).build());
    }

    public void updateRuntimeProperties(Map<String, DeploymentRuntimeProperties> propertiesMap) {
        this.runtimePropertiesCacheRef.set(propertiesMap);
    }

    public void removeDeployProperties(String deploymentId) {
        this.deployPropertiesCache.remove(deploymentId);
    }
}

