/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.service.debugger.util;

import jakarta.validation.constraints.NotNull;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.camel.Exchange;
import org.qubership.integration.platform.engine.camel.components.servlet.exception.ChainGlobalExceptionHandler;
import org.qubership.integration.platform.engine.camel.components.servlet.exception.annotations.ChainExceptionHandler;
import org.qubership.integration.platform.engine.errorhandling.errorcode.ErrorCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ChainExceptionResponseHandlerService {
    private static final Logger log = LoggerFactory.getLogger(ChainExceptionResponseHandlerService.class);
    private final ChainGlobalExceptionHandler chainGlobalExceptionHandler;

    @Autowired
    public ChainExceptionResponseHandlerService(ChainGlobalExceptionHandler chainGlobalExceptionHandler) {
        this.chainGlobalExceptionHandler = chainGlobalExceptionHandler;
    }

    public void handleExceptionResponse(Exchange exchange, Exception exception) throws InvocationTargetException, IllegalAccessException {
        Method method = this.getExceptionMethod(exception);
        method.invoke((Object)this.chainGlobalExceptionHandler, new Object[]{exception, exchange, ErrorCode.match(exception), this.getAdditionalExtraParams(exchange)});
    }

    private Method getExceptionMethod(@NotNull Throwable exception) {
        Method[] methods = ChainGlobalExceptionHandler.class.getDeclaredMethods();
        Method defaultMethod = null;
        for (Method method : methods) {
            ChainExceptionHandler annotation = method.getAnnotation(ChainExceptionHandler.class);
            if (annotation == null) continue;
            if (annotation.value().length == 0) {
                defaultMethod = method;
                continue;
            }
            if (!Arrays.stream(annotation.value()).anyMatch(c -> c.equals(exception.getClass()))) continue;
            return method;
        }
        return defaultMethod;
    }

    private Map<String, String> getAdditionalExtraParams(Exchange exchange) {
        return new HashMap<String, String>(Map.of("sessionId", (String)exchange.getProperty("internalProperty_sessionId", String.class), "failedElementId", (String)exchange.getProperty("failed-element-id", String.class)));
    }
}

