/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.qubership.integration.platform.engine.model.SessionElementProperty;
import org.qubership.integration.platform.engine.model.constants.CamelConstants;
import org.qubership.integration.platform.engine.service.debugger.util.json.JsonSerializationHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExchangeUtils {
    private static final Logger log = LoggerFactory.getLogger(ExchangeUtils.class);

    public static boolean isCommonOrSystemVariableMap(String propertyKey) {
        return "variables".equals(propertyKey);
    }

    public static void interruptExchange(Exchange exchange, int responseCode) {
        ExchangeUtils.interruptExchange(exchange, responseCode, null);
    }

    public static void interruptExchange(Exchange exchange, int responseCode, Exception e) {
        exchange.getExchangeExtension().setInterrupted(true);
        Message message = exchange.getMessage();
        message.setBody((Object)(e == null ? "" : e.getMessage()));
        message.removeHeaders("*");
        message.setHeader("CamelHttpResponseCode", (Object)responseCode);
    }

    public static Map<String, SessionElementProperty> prepareExchangePropertiesForLogging(Exchange exchange) {
        HashMap<String, SessionElementProperty> exchangePropertiesForLogging = new HashMap<String, SessionElementProperty>();
        for (Map.Entry entry : exchange.getProperties().entrySet()) {
            String key = (String)entry.getKey();
            boolean propertyShouldBeLogged = !ExchangeUtils.isCommonOrSystemVariableMap(key) && !CamelConstants.isInternalProperty(key);
            if (!propertyShouldBeLogged) continue;
            exchangePropertiesForLogging.put(key, ExchangeUtils.serializePropertyValue(entry.getValue()));
        }
        return exchangePropertiesForLogging;
    }

    private static SessionElementProperty serializePropertyValue(Object value) {
        if (value != null) {
            try {
                if (value instanceof String) {
                    String stringValue = (String)value;
                    return SessionElementProperty.builder().type(String.class.getName()).value(stringValue).build();
                }
                return SessionElementProperty.builder().type(value.getClass().getName()).value(value instanceof Iterable || value instanceof Map ? value.toString() : JsonSerializationHelper.serializeJson(value)).build();
            }
            catch (JsonProcessingException exception) {
                log.error(exception.getMessage());
            }
        }
        return SessionElementProperty.NULL_PROPERTY;
    }

    public static void setContentTypeIfMissing(Exchange exchange) {
        Message message = exchange.getMessage();
        Map headersMap = message.getHeaders();
        if (!headersMap.containsKey("Content-Type")) {
            headersMap.put("Content-Type", "application/json");
        }
    }

    public static Map<String, Object> filterExchangeMap(Map<String, Object> map, Predicate<Map.Entry<String, Object>> filterPredicate) {
        return map.entrySet().stream().filter(filterPredicate).filter(entry -> entry.getValue() != null).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }
}

