/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.util;

import java.net.MalformedURLException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SimpleHttpUriUtils {
    private static final String PROTOCOL_DOMAIN_REGEX = "^https?://[^:/]+(:\\d{1,5})?";
    private static final String PROTOCOL_ADDRESS_REGEX = "^[^:/]+(:\\d{1,5})?";
    private static final Pattern PROTOCOL_DOMAIN_PATTERN = Pattern.compile("^https?://[^:/]+(:\\d{1,5})?");
    private static final Pattern PROTOCOL_ADDRESS_PATTERN = Pattern.compile("^[^:/]+(:\\d{1,5})?");

    public static String formatUri(String uri) throws MalformedURLException {
        if (uri == null) {
            return null;
        }
        Matcher matcher = PROTOCOL_DOMAIN_PATTERN.matcher(uri);
        if (matcher.find()) {
            return uri;
        }
        matcher = PROTOCOL_ADDRESS_PATTERN.matcher(uri);
        if (matcher.find()) {
            return "https://" + uri;
        }
        throw new MalformedURLException("URI " + uri + " invalid, failed to format");
    }
}

