/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.camel.components.directvm;

import org.apache.camel.AsyncEndpoint;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.DefaultEndpoint;
import org.qubership.integration.platform.engine.camel.components.directvm.ChainBlockingProducer;
import org.qubership.integration.platform.engine.camel.components.directvm.ChainComponent;
import org.qubership.integration.platform.engine.camel.components.directvm.ChainConsumer;
import org.qubership.integration.platform.engine.camel.components.directvm.ChainProcessor;
import org.qubership.integration.platform.engine.camel.components.directvm.ChainProducer;

@UriEndpoint(firstVersion="2.10.0", scheme="cip-chain", title="Chain", syntax="cip-chain:name", category={Category.CORE})
public class ChainEndpoint
extends DefaultEndpoint
implements AsyncEndpoint {
    @UriPath(description="Name of direct-vm endpoint")
    @Metadata(required=true)
    private String name;
    @UriParam(label="producer", defaultValue="true")
    private boolean block = true;
    @UriParam(label="producer", defaultValue="30000", javaType="java.time.Duration")
    private long timeout = 30000L;
    @UriParam(label="producer")
    private boolean failIfNoConsumers = true;
    @UriParam(label="producer,advanced")
    private HeaderFilterStrategy headerFilterStrategy;
    @UriParam(label="advanced", defaultValue="true")
    private boolean propagateProperties = true;

    public ChainEndpoint(String endpointUri, ChainComponent component) {
        super(endpointUri, (Component)component);
    }

    public ChainComponent getComponent() {
        return (ChainComponent)super.getComponent();
    }

    public Producer createProducer() throws Exception {
        if (this.block) {
            return new ChainBlockingProducer(this);
        }
        return new ChainProducer(this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        ChainConsumer answer = new ChainConsumer(this, (Processor)new ChainProcessor(processor, this));
        this.configureConsumer((Consumer)answer);
        return answer;
    }

    public ChainConsumer getConsumer() {
        return this.getComponent().getConsumer(this);
    }

    public boolean isBlock() {
        return this.block;
    }

    public void setBlock(boolean block) {
        this.block = block;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public boolean isFailIfNoConsumers() {
        return this.failIfNoConsumers;
    }

    public void setFailIfNoConsumers(boolean failIfNoConsumers) {
        this.failIfNoConsumers = failIfNoConsumers;
    }

    public HeaderFilterStrategy getHeaderFilterStrategy() {
        return this.headerFilterStrategy == null ? this.getComponent().getHeaderFilterStrategy() : this.headerFilterStrategy;
    }

    public void setHeaderFilterStrategy(HeaderFilterStrategy headerFilterStrategy) {
        this.headerFilterStrategy = headerFilterStrategy;
    }

    public boolean isPropagateProperties() {
        return this.propagateProperties;
    }

    public void setPropagateProperties(boolean propagateProperties) {
        this.propagateProperties = propagateProperties;
    }
}

