/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.camel.components.servlet;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.camel.Exchange;
import org.apache.camel.http.common.HttpHeaderFilterStrategy;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.qubership.integration.platform.engine.camel.components.context.propagation.ContextPropsProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ServletCustomFilterStrategy
extends HttpHeaderFilterStrategy {
    private static final Collection<String> FILTERED_HEADERS = List.of("span-id", "trace-id", "x-requestedsystem");
    private final Optional<ContextPropsProvider> contextPropsProvider;

    @Autowired
    public ServletCustomFilterStrategy(Optional<ContextPropsProvider> contextPropsProvider) {
        this.contextPropsProvider = contextPropsProvider;
        this.getOutFilter().addAll(FILTERED_HEADERS);
    }

    protected boolean extendedFilter(HeaderFilterStrategy.Direction direction, String headerName, Object headerValue, Exchange exchange) {
        return (HeaderFilterStrategy.Direction.OUT.equals((Object)direction) && this.isHeaderInContext(headerName)) == this.isFilterOnMatch();
    }

    private boolean isHeaderInContext(String name) {
        return this.contextPropsProvider.map(ContextPropsProvider::getDownstreamHeaders).map(headers -> Objects.nonNull(headers) && headers.contains(name)).orElse(false);
    }
}

