/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.service;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class MergedVariablesMap<K, V>
extends HashMap<K, V> {
    private final Set<K> securedVariableNames = new HashSet();

    MergedVariablesMap() {
    }

    private Set<K> getSecuredVariableNames() {
        return this.securedVariableNames;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        if (map instanceof MergedVariablesMap) {
            this.securedVariableNames.addAll(((MergedVariablesMap)map).getSecuredVariableNames());
        }
        super.putAll(map);
    }

    public void putAll(Map<? extends K, ? extends V> map, boolean isSecret) {
        if (isSecret) {
            this.securedVariableNames.addAll(map.keySet());
        }
        super.putAll(map);
    }

    @Override
    public V remove(Object key) {
        this.securedVariableNames.remove(key);
        return super.remove(key);
    }

    @Override
    public boolean remove(Object key, Object value) {
        this.securedVariableNames.remove(key);
        return super.remove(key, value);
    }

    @Override
    public String toString() {
        Iterator i = this.entrySet().iterator();
        if (!i.hasNext()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        while (true) {
            Map.Entry e;
            Object key;
            String value = !this.securedVariableNames.contains(key = (e = (Map.Entry)i.next()).getKey()) ? e.getValue() : "***";
            sb.append((Object)(key == this ? "(this Map)" : key));
            sb.append('=');
            sb.append((Object)(value == this ? "(this Map)" : value));
            if (!i.hasNext()) {
                return sb.append('}').toString();
            }
            sb.append(',').append(' ');
        }
    }
}

