/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.service.deployment.processing;

import java.util.Optional;
import org.apache.camel.spring.SpringCamelContext;
import org.qubership.integration.platform.engine.model.deployment.update.DeploymentConfiguration;
import org.qubership.integration.platform.engine.model.deployment.update.DeploymentInfo;
import org.qubership.integration.platform.engine.model.deployment.update.ElementProperties;
import org.qubership.integration.platform.engine.service.deployment.processing.DeploymentProcessingAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public abstract class ElementProcessingAction
implements DeploymentProcessingAction {
    private static final Logger log = LoggerFactory.getLogger(ElementProcessingAction.class);

    public void execute(SpringCamelContext context, DeploymentInfo deploymentInfo, DeploymentConfiguration deploymentConfiguration) {
        Optional.ofNullable(deploymentConfiguration).map(DeploymentConfiguration::getProperties).ifPresent(properties -> properties.stream().filter(arg_0 -> this.applicableTo(arg_0)).forEach(elementProperties -> this.processElement(context, elementProperties, deploymentInfo)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processElement(SpringCamelContext context, ElementProperties elementProperties, DeploymentInfo deploymentInfo) {
        try {
            String elementId = (String)elementProperties.getProperties().get("elementId");
            log.debug("Applying action {} for deployment {}, element {}", new Object[]{this.getClass().getSimpleName(), deploymentInfo.getDeploymentId(), elementId});
            MDC.put((String)"elementId", (String)elementId);
            this.apply(context, elementProperties, deploymentInfo);
        }
        finally {
            MDC.remove((String)"elementId");
        }
    }

    public abstract boolean applicableTo(ElementProperties var1);

    public abstract void apply(SpringCamelContext var1, ElementProperties var2, DeploymentInfo var3);
}

