/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.service.deployment.processing.actions.context.create;

import io.micrometer.common.KeyValues;
import org.apache.camel.spring.SpringCamelContext;
import org.qubership.integration.platform.engine.camel.components.servlet.ServletTagsProvider;
import org.qubership.integration.platform.engine.model.deployment.update.DeploymentInfo;
import org.qubership.integration.platform.engine.model.deployment.update.ElementProperties;
import org.qubership.integration.platform.engine.service.deployment.processing.ElementProcessingAction;
import org.qubership.integration.platform.engine.service.deployment.processing.actions.context.create.helpers.ChainElementTypeHelper;
import org.qubership.integration.platform.engine.service.deployment.processing.actions.context.create.helpers.MetricTagsHelper;
import org.qubership.integration.platform.engine.service.deployment.processing.qualifiers.OnAfterDeploymentContextCreated;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@OnAfterDeploymentContextCreated
public class HttpTriggerDependencyBinder
extends ElementProcessingAction {
    private final MetricTagsHelper metricTagsHelper;

    @Autowired
    public HttpTriggerDependencyBinder(MetricTagsHelper metricTagsHelper) {
        this.metricTagsHelper = metricTagsHelper;
    }

    public boolean applicableTo(ElementProperties properties) {
        return ChainElementTypeHelper.isHttpTriggerElement((ElementProperties)properties);
    }

    public void apply(SpringCamelContext context, ElementProperties elementProperties, DeploymentInfo deploymentInfo) {
        KeyValues tags = this.metricTagsHelper.buildMetricTags(deploymentInfo, elementProperties, deploymentInfo.getChainName());
        ServletTagsProvider servletTagsProvider = new ServletTagsProvider(tags);
        String elementId = elementProperties.getElementId();
        context.getRegistry().bind(elementId, ServletTagsProvider.class, (Object)servletTagsProvider);
    }
}

