/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.camel;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.commons.lang3.StringUtils;
import org.qubership.integration.platform.engine.service.debugger.util.MessageHelper;
import org.qubership.integration.platform.engine.util.MDCUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class CorrelationIdSetter {
    private static final Logger log = LoggerFactory.getLogger(CorrelationIdSetter.class);
    public static final String CORRELATION_ID_POSITION = "correlationIdPosition";
    public static final String CORRELATION_ID_NAME = "correlationIdName";
    public static final String CORRELATION_ID = "correlationId";
    public static final String HEADER = "Header";
    public static final String BODY = "Body";
    private final ObjectMapper objectMapper;

    @Autowired
    public CorrelationIdSetter(@Qualifier(value="jsonMapper") ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public void setCorrelationId(Exchange exchange) {
        if (exchange.getProperty(CORRELATION_ID_POSITION) != null && exchange.getProperty(CORRELATION_ID_NAME) != null) {
            String correlationIdPosition = String.valueOf(exchange.getProperty(CORRELATION_ID_POSITION));
            String correlationIdName = String.valueOf(exchange.getProperty(CORRELATION_ID_NAME));
            if (HEADER.equals(correlationIdPosition)) {
                if (exchange.getMessage().getHeader(correlationIdName) != null) {
                    String correlationId = String.valueOf(exchange.getMessage().getHeader(correlationIdName));
                    exchange.setProperty(CORRELATION_ID, (Object)correlationId);
                    if (StringUtils.isNotBlank((CharSequence)correlationId)) {
                        MDCUtil.setCorrelationId(correlationId);
                    }
                } else {
                    exchange.setProperty(CORRELATION_ID, null);
                }
            } else if (BODY.equals(correlationIdPosition)) {
                try {
                    Map body = (Map)this.objectMapper.readValue(MessageHelper.extractBody(exchange), HashMap.class);
                    if (body.containsKey(correlationIdName)) {
                        String correlationId = String.valueOf(body.get(correlationIdName));
                        exchange.setProperty(CORRELATION_ID, (Object)correlationId);
                        if (StringUtils.isNotBlank((CharSequence)correlationId)) {
                            MDCUtil.setCorrelationId(correlationId);
                        }
                    }
                }
                catch (IOException e) {
                    log.error("Error while finding correlation id with name {}", (Object)correlationIdName);
                }
            }
        }
    }
}

