/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.camel.components.servlet;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.UUID;
import org.apache.camel.Category;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.component.servlet.ServletComponent;
import org.apache.camel.component.servlet.ServletEndpoint;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.http.client.utils.URIBuilder;
import org.qubership.integration.platform.engine.camel.components.servlet.ServletCustomConsumer;
import org.qubership.integration.platform.engine.camel.components.servlet.ServletTagsProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UriEndpoint(firstVersion="2.0.0", scheme="servlet-custom", extendsScheme="http", title="Servlet", syntax="servlet-custom:contextPath", consumerOnly=true, category={Category.HTTP})
public class ServletCustomEndpoint
extends ServletEndpoint {
    private static final Logger log = LoggerFactory.getLogger(ServletCustomEndpoint.class);
    @UriParam(label="advanced", description="Metric tags provider")
    private ServletTagsProvider tagsProvider;
    @UriParam(label="advanced", description="Unique ID for servlet")
    private String servletCustomId = UUID.randomUUID().toString();

    public ServletCustomEndpoint(String endPointURI, ServletComponent component, URI httpUri, HeaderFilterStrategy headerFilterStrategy) throws URISyntaxException {
        super(endPointURI, component, httpUri);
        super.setEndpointUri(endPointURI + "&servletCustomId=" + this.servletCustomId);
        super.setHttpUri(new URIBuilder(httpUri).addParameter("servletCustomId", this.servletCustomId).build());
        super.setHeaderFilterStrategy(headerFilterStrategy);
    }

    public ServletTagsProvider getTagsProvider() {
        return this.tagsProvider;
    }

    public void setTagsProvider(ServletTagsProvider tagsProvider) {
        this.tagsProvider = tagsProvider;
    }

    public String getServletCustomId() {
        return this.servletCustomId;
    }

    public void setServletCustomId(String servletCustomId) {
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        ServletCustomConsumer answer = new ServletCustomConsumer(this, processor);
        this.configureConsumer((Consumer)answer);
        return answer;
    }
}

