/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.security;

import java.util.Collection;
import java.util.Objects;
import org.apache.camel.Exchange;
import org.qubership.integration.platform.engine.security.QipSecurityAccessPolicy;
import org.qubership.integration.platform.engine.util.DevModeUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.AccessDecisionVoter;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.access.vote.RoleVoter;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Component;

@Component
public class ExchangeRolesVoter
implements AccessDecisionVoter<Exchange> {
    private final RoleVoter roleVoter;
    private final DevModeUtil devModeUtil;

    @Autowired
    public ExchangeRolesVoter(RoleVoter roleVoter, DevModeUtil devModeUtil) {
        this.roleVoter = roleVoter;
        this.devModeUtil = devModeUtil;
    }

    public boolean supports(ConfigAttribute attribute) {
        return true;
    }

    public boolean supports(Class<?> clazz) {
        return Exchange.class.isAssignableFrom(clazz);
    }

    public int vote(Authentication authentication, Exchange object, Collection<ConfigAttribute> attributes) {
        QipSecurityAccessPolicy accessPolicy = this.extractSecurityPolicy(object);
        return Objects.isNull(accessPolicy) || this.devModeUtil.isDevMode() ? 1 : this.roleVoter.vote(authentication, (Object)object, accessPolicy.getConfigAttributes());
    }

    private QipSecurityAccessPolicy extractSecurityPolicy(Exchange exchange) {
        QipSecurityAccessPolicy accessPolicy = (QipSecurityAccessPolicy)exchange.getProperty("internalProperty_rbac_access_policy", QipSecurityAccessPolicy.class);
        if (Objects.nonNull(accessPolicy)) {
            exchange.removeProperty("internalProperty_rbac_access_policy");
        }
        return accessPolicy;
    }
}

