/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.service;

import com.google.common.collect.MinMaxPriorityQueue;
import jakarta.persistence.EntityNotFoundException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.spi.InflightRepository;
import org.apache.camel.spring.SpringCamelContext;
import org.qubership.integration.platform.engine.errorhandling.ChainExecutionTerminatedException;
import org.qubership.integration.platform.engine.model.deployment.properties.CamelDebuggerProperties;
import org.qubership.integration.platform.engine.rest.v1.dto.LiveExchangeDTO;
import org.qubership.integration.platform.engine.service.IntegrationRuntimeService;
import org.qubership.integration.platform.engine.service.debugger.CamelDebuggerPropertiesService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class LiveExchangesService {
    private static final Logger log = LoggerFactory.getLogger(LiveExchangesService.class);
    private static final Comparator<InflightExchangeHolder> EXCHANGE_COMPARATOR = Comparator.comparingLong(holder -> holder.getInflightExchange().getDuration() * -1L);
    private final IntegrationRuntimeService integrationRuntimeService;
    private final CamelDebuggerPropertiesService propertiesService;

    public LiveExchangesService(IntegrationRuntimeService integrationRuntimeService, CamelDebuggerPropertiesService propertiesService) {
        this.integrationRuntimeService = integrationRuntimeService;
        this.propertiesService = propertiesService;
    }

    public List<LiveExchangeDTO> getTopLiveExchanges(int amount) {
        ArrayList<LiveExchangeDTO> result = new ArrayList<LiveExchangeDTO>();
        MinMaxPriorityQueue inflightExchanges = MinMaxPriorityQueue.orderedBy(EXCHANGE_COMPARATOR).maximumSize(amount).create();
        for (Map.Entry entry : this.integrationRuntimeService.getCache().getContexts().entrySet()) {
            String deploymentId = (String)entry.getKey();
            SpringCamelContext context = (SpringCamelContext)entry.getValue();
            List<InflightExchangeHolder> exchangeHolders = context.getInflightRepository().browse(amount, true).stream().map(ex -> new InflightExchangeHolder((InflightRepository.InflightExchange)ex, deploymentId)).toList();
            inflightExchanges.addAll(exchangeHolders);
        }
        for (InflightExchangeHolder exchangeHolder : inflightExchanges) {
            Exchange exchange = exchangeHolder.getInflightExchange().getExchange();
            Long sessionStartTime = (Long)exchange.getProperty("internalProperty_startTimeMs", Long.class);
            Long sessionDuration = sessionStartTime == null ? null : Long.valueOf(System.currentTimeMillis() - sessionStartTime);
            Long exchangeStartTime = (Long)exchange.getProperty("internalProperty_exchangeStartTimeMs", Long.class);
            Long exchangeDuration = exchangeStartTime == null ? null : Long.valueOf(System.currentTimeMillis() - exchangeStartTime);
            CamelDebuggerProperties properties = this.propertiesService.getProperties(exchange, exchangeHolder.getDeploymentId());
            String chainId = properties.getDeploymentInfo().getChainId();
            result.add(LiveExchangeDTO.builder().exchangeId(exchange.getExchangeId()).deploymentId(exchangeHolder.getDeploymentId()).sessionId((String)exchange.getProperty("internalProperty_sessionId", String.class)).chainId(chainId).sessionStartTime(sessionStartTime).sessionDuration(sessionDuration).sessionLogLevel(properties.getActualRuntimeProperties().calculateSessionLevel(exchange)).duration(exchangeDuration).main((Boolean)exchange.getProperty("internalProperty_isMainExchange", Boolean.class)).build());
        }
        return result;
    }

    public void killLiveExchangeById(String deploymentId, String exchangeId) {
        SpringCamelContext context = (SpringCamelContext)this.integrationRuntimeService.getCache().getContexts().get(deploymentId);
        if (context == null) {
            throw new EntityNotFoundException("No deployment found for id " + deploymentId);
        }
        Exchange exchange = context.getInflightRepository().browse().stream().filter(inflightExchange -> exchangeId.equals(inflightExchange.getExchange().getExchangeId())).findAny().orElseThrow(() -> new EntityNotFoundException("No live exchange found for deployment id " + deploymentId)).getExchange();
        exchange.setException((Throwable)new ChainExecutionTerminatedException("Chain was interrupted manually"));
    }

    private static class InflightExchangeHolder {
        private final InflightRepository.InflightExchange inflightExchange;
        private final String deploymentId;

        public InflightExchangeHolder(InflightRepository.InflightExchange inflightExchange, String deploymentId) {
            this.inflightExchange = inflightExchange;
            this.deploymentId = deploymentId;
        }

        public InflightRepository.InflightExchange getInflightExchange() {
            return this.inflightExchange;
        }

        public String getDeploymentId() {
            return this.deploymentId;
        }
    }
}

