/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.service.deployment.processing.actions.context.create;

import io.micrometer.core.instrument.binder.httpcomponents.hc5.MicrometerHttpClientInterceptor;
import java.net.URISyntaxException;
import java.util.Optional;
import org.apache.camel.component.http.HttpClientConfigurer;
import org.apache.camel.spring.SpringCamelContext;
import org.apache.hc.core5.http.HttpRequestInterceptor;
import org.qubership.integration.platform.engine.model.ChainElementType;
import org.qubership.integration.platform.engine.model.deployment.update.DeploymentInfo;
import org.qubership.integration.platform.engine.model.deployment.update.ElementProperties;
import org.qubership.integration.platform.engine.service.debugger.metrics.MetricsStore;
import org.qubership.integration.platform.engine.service.deployment.processing.ElementProcessingAction;
import org.qubership.integration.platform.engine.service.deployment.processing.actions.context.create.helpers.ChainElementTypeHelper;
import org.qubership.integration.platform.engine.service.deployment.processing.actions.context.create.helpers.MetricTagsHelper;
import org.qubership.integration.platform.engine.service.deployment.processing.qualifiers.OnAfterDeploymentContextCreated;
import org.qubership.integration.platform.engine.service.testing.TestingService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@OnAfterDeploymentContextCreated
public class HttpSenderDependencyBinder
extends ElementProcessingAction {
    private static final Logger log = LoggerFactory.getLogger(HttpSenderDependencyBinder.class);
    private final MetricsStore metricsStore;
    private final MetricTagsHelper metricTagsHelper;
    private final Optional<TestingService> testingService;

    @Autowired
    public HttpSenderDependencyBinder(MetricsStore metricsStore, MetricTagsHelper metricTagsHelper, Optional<TestingService> testingService) {
        this.metricsStore = metricsStore;
        this.metricTagsHelper = metricTagsHelper;
        this.testingService = testingService;
    }

    @Override
    public boolean applicableTo(ElementProperties properties) {
        return HttpSenderDependencyBinder.isHttpChainElement(properties) && !ChainElementTypeHelper.isHttpTriggerElement(properties);
    }

    @Override
    public void apply(SpringCamelContext context, ElementProperties elementProperties, DeploymentInfo deploymentInfo) {
        HttpClientConfigurer httpClientConfigurer = clientBuilder -> {
            if (this.metricsStore.isMetricsEnabled()) {
                MicrometerHttpClientInterceptor interceptor = new MicrometerHttpClientInterceptor(this.metricsStore.getMeterRegistry(), request -> {
                    try {
                        return elementProperties.getProperties().get("integrationOperationPath") != null ? elementProperties.getProperties().get("integrationOperationPath") : request.getUri().toString();
                    }
                    catch (URISyntaxException e) {
                        log.error("Failed to get URI from request");
                        return "";
                    }
                }, this.metricTagsHelper.buildMetricTagsLegacy(deploymentInfo, elementProperties, deploymentInfo.getChainName()), true);
                clientBuilder.addRequestInterceptorFirst(interceptor.getRequestInterceptor());
                clientBuilder.addResponseInterceptorLast(interceptor.getResponseInterceptor());
            }
            this.testingService.ifPresent(s -> {
                if (s.canBeMocked(elementProperties)) {
                    HttpRequestInterceptor endpointMockInterceptor = s.buildEndpointMockInterceptor(deploymentInfo.getChainId(), elementProperties);
                    clientBuilder.addRequestInterceptorFirst(endpointMockInterceptor);
                    clientBuilder.setRoutePlanner(s.buildRoutePlanner(deploymentInfo.getChainId(), elementProperties));
                }
            });
            if (!Boolean.parseBoolean(elementProperties.getProperties().getOrDefault("reuseEstablishedConnection", "true"))) {
                clientBuilder.setConnectionReuseStrategy((request, response, httpContext) -> false);
            }
            clientBuilder.disableAutomaticRetries();
        };
        String elementId = elementProperties.getElementId();
        context.getRegistry().bind(elementId, HttpClientConfigurer.class, (Object)httpClientConfigurer);
    }

    private static boolean isHttpChainElement(ElementProperties properties) {
        String elementType = properties.getProperties().get("elementType");
        ChainElementType chainElementType = ChainElementType.fromString(elementType);
        String protocol = properties.getProperties().get("integrationOperationProtocolType");
        return ChainElementType.isHttpElement(chainElementType) && (!ChainElementType.SERVICE_CALL.equals((Object)chainElementType) || "http".equals(protocol) || "graphql".equals(protocol));
    }
}

