/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.service.externallibrary;

import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyShell;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import org.apache.camel.Exchange;
import org.apache.camel.language.groovy.GroovyShellFactory;
import org.qubership.integration.platform.engine.service.externallibrary.ExternalLibraryService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ExternalLibraryGroovyShellFactory
implements GroovyShellFactory {
    private static final Logger log = LoggerFactory.getLogger(ExternalLibraryGroovyShellFactory.class);
    private final Optional<ExternalLibraryService> externalLibraryService;

    @Autowired
    public ExternalLibraryGroovyShellFactory(Optional<ExternalLibraryService> externalLibraryService) {
        this.externalLibraryService = externalLibraryService;
    }

    public GroovyShell createGroovyShell(Exchange exchange) {
        log.debug("Requesting groovy shell for {}", (Object)(Objects.isNull(exchange) ? Collections.emptyMap() : exchange.getProperties()));
        GroovyClassLoader groovyClassLoader = new GroovyClassLoader(this.externalLibraryService.isPresent() ? this.externalLibraryService.get().getShellClassLoader() : this.getClass().getClassLoader());
        return new GroovyShell((ClassLoader)groovyClassLoader);
    }
}

