/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.camel.components.rabbitmq;

import com.rabbitmq.client.MetricsCollector;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Map;
import javax.net.ssl.TrustManager;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.component.springrabbit.SpringRabbitMQConstants;
import org.apache.camel.component.springrabbit.SpringRabbitMQEndpoint;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.connection.CachingConnectionFactory;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.boot.autoconfigure.amqp.RabbitConnectionDetails;
import org.springframework.util.Assert;

@UriEndpoint(firstVersion="3.8.0", scheme="rabbitmq-custom", title="Spring RabbitMQ custom", syntax="rabbitmq-custom:exchangeName", category={Category.MESSAGING}, headersClass=SpringRabbitMQConstants.class)
public class SpringRabbitMQCustomEndpoint
extends SpringRabbitMQEndpoint {
    private static final Logger log = LoggerFactory.getLogger(SpringRabbitMQCustomEndpoint.class);
    @UriParam(label="common")
    private String addresses;
    @UriParam(label="security", defaultValue="guest", secret=true)
    private String username = "guest";
    @UriParam(label="security", defaultValue="guest", secret=true)
    private String password = "guest";
    @UriParam(label="common", defaultValue="/")
    private String vhost = "/";
    @UriParam(label="advanced", defaultValue="60000")
    private int connectionTimeout = 60000;
    @UriParam(label="advanced", defaultValue="2047")
    private int requestedChannelMax = 2047;
    @UriParam(label="advanced", defaultValue="0")
    private int requestedFrameMax = 0;
    @UriParam(label="advanced", defaultValue="60")
    private int requestedHeartbeat = 60;
    @UriParam(label="security")
    private String sslProtocol;
    @UriParam(label="security")
    private TrustManager trustManager;
    @UriParam(label="advanced")
    private Map<String, Object> clientProperties;
    @UriParam(label="common", description="Metrics collector")
    private MetricsCollector metricsCollector;

    public SpringRabbitMQCustomEndpoint(String endpointUri, Component component, String exchangeName) {
        super(endpointUri, component, exchangeName);
    }

    public void configureProperties(Map<String, Object> options) {
        super.configureProperties(options);
        this.setConnectionFactory(this.buildConnectionFactory());
    }

    private ConnectionFactory buildConnectionFactory() {
        com.rabbitmq.client.ConnectionFactory factory = new com.rabbitmq.client.ConnectionFactory();
        factory.setAutomaticRecoveryEnabled(false);
        return new CachingConnectionFactory(this.setupFactory(factory));
    }

    private com.rabbitmq.client.ConnectionFactory setupFactory(com.rabbitmq.client.ConnectionFactory factory) {
        factory.setMetricsCollector(this.metricsCollector);
        ArrayList<RabbitConnectionDetails.Address> addresses = new ArrayList<RabbitConnectionDetails.Address>();
        for (String address : this.getAddresses().split(",")) {
            int portSeparatorIndex = address.lastIndexOf(58);
            String host = address.substring(0, portSeparatorIndex);
            String port = address.substring(portSeparatorIndex + 1);
            addresses.add(new RabbitConnectionDetails.Address(host, Integer.parseInt(port)));
        }
        Assert.state((!addresses.isEmpty() ? 1 : 0) != 0, (String)"Address list is empty");
        factory.setHost(((RabbitConnectionDetails.Address)addresses.get(0)).host());
        factory.setPort(((RabbitConnectionDetails.Address)addresses.get(0)).port());
        factory.setUsername(this.getUsername());
        factory.setPassword(this.getPassword());
        factory.setVirtualHost(this.getVhost());
        if (this.getClientProperties() != null) {
            factory.setClientProperties(this.getClientProperties());
        }
        factory.setConnectionTimeout(this.getConnectionTimeout());
        factory.setRequestedChannelMax(this.getRequestedChannelMax());
        factory.setRequestedFrameMax(this.getRequestedFrameMax());
        factory.setRequestedHeartbeat(this.getRequestedHeartbeat());
        this.setupSSL(factory);
        return factory;
    }

    private void setupSSL(com.rabbitmq.client.ConnectionFactory factory) {
        if (this.getSslProtocol() != null) {
            try {
                if (this.getSslProtocol().equals("true")) {
                    factory.useSslProtocol();
                } else if (this.getTrustManager() == null) {
                    factory.useSslProtocol(this.getSslProtocol());
                } else {
                    factory.useSslProtocol(this.getSslProtocol(), this.getTrustManager());
                }
            }
            catch (KeyManagementException | NoSuchAlgorithmException e) {
                throw new IllegalArgumentException("Invalid sslProtocol " + this.getSslProtocol(), e);
            }
        }
    }

    public String getQueues() {
        return super.getQueues();
    }

    public void setAddresses(String addresses) {
        this.addresses = addresses;
    }

    public String getAddresses() {
        return this.addresses;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getVhost() {
        return this.vhost;
    }

    public void setVhost(String vhost) {
        this.vhost = vhost;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public int getRequestedChannelMax() {
        return this.requestedChannelMax;
    }

    public void setRequestedChannelMax(int requestedChannelMax) {
        this.requestedChannelMax = requestedChannelMax;
    }

    public int getRequestedFrameMax() {
        return this.requestedFrameMax;
    }

    public void setRequestedFrameMax(int requestedFrameMax) {
        this.requestedFrameMax = requestedFrameMax;
    }

    public int getRequestedHeartbeat() {
        return this.requestedHeartbeat;
    }

    public void setRequestedHeartbeat(int requestedHeartbeat) {
        this.requestedHeartbeat = requestedHeartbeat;
    }

    public String getSslProtocol() {
        return this.sslProtocol;
    }

    public void setSslProtocol(String sslProtocol) {
        this.sslProtocol = sslProtocol;
    }

    public TrustManager getTrustManager() {
        return this.trustManager;
    }

    public void setTrustManager(TrustManager trustManager) {
        this.trustManager = trustManager;
    }

    public Map<String, Object> getClientProperties() {
        return this.clientProperties;
    }

    public void setClientProperties(Map<String, Object> clientProperties) {
        this.clientProperties = clientProperties;
    }

    public MetricsCollector getMetricsCollector() {
        return this.metricsCollector;
    }

    public void setMetricsCollector(MetricsCollector metricsCollector) {
        this.metricsCollector = metricsCollector;
    }
}

