/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.service.deployment.processing.actions.context.create;

import jakarta.jms.ConnectionFactory;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ThreadFactory;
import javax.naming.NamingException;
import org.apache.camel.component.jms.JmsComponent;
import org.apache.camel.component.jms.JmsConfiguration;
import org.apache.camel.spi.InterceptStrategy;
import org.apache.camel.spi.ThreadPoolProfile;
import org.apache.camel.spring.SpringCamelContext;
import org.apache.commons.lang3.StringUtils;
import org.qubership.integration.platform.engine.jms.weblogic.WeblogicSecureThreadFactory;
import org.qubership.integration.platform.engine.jms.weblogic.WeblogicSecurityBean;
import org.qubership.integration.platform.engine.jms.weblogic.WeblogicSecurityInterceptStrategy;
import org.qubership.integration.platform.engine.model.ChainElementType;
import org.qubership.integration.platform.engine.model.deployment.update.DeploymentInfo;
import org.qubership.integration.platform.engine.model.deployment.update.ElementProperties;
import org.qubership.integration.platform.engine.service.VariablesService;
import org.qubership.integration.platform.engine.service.deployment.processing.ElementProcessingAction;
import org.qubership.integration.platform.engine.service.deployment.processing.qualifiers.OnAfterDeploymentContextCreated;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.task.TaskExecutor;
import org.springframework.jms.support.destination.DestinationResolver;
import org.springframework.jms.support.destination.JndiDestinationResolver;
import org.springframework.jndi.JndiObjectFactoryBean;
import org.springframework.jndi.JndiTemplate;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Component;

@Component
@OnAfterDeploymentContextCreated
public class JmsElementDependencyBinder
extends ElementProcessingAction {
    private final VariablesService variablesService;
    private final ObjectProvider<WeblogicSecurityBean> wlSecurityBeanProvider;
    private final ObjectProvider<WeblogicSecurityInterceptStrategy> wlSecurityInterceptStrategyProvider;
    private final ObjectProvider<WeblogicSecureThreadFactory> wlSecureThreadFactoryProvider;

    @Autowired
    public JmsElementDependencyBinder(VariablesService variablesService, ObjectProvider<WeblogicSecurityBean> wlSecurityBeanProvider, ObjectProvider<WeblogicSecurityInterceptStrategy> wlSecurityInterceptStrategyProvider, ObjectProvider<WeblogicSecureThreadFactory> wlSecureThreadFactoryProvider) {
        this.variablesService = variablesService;
        this.wlSecurityBeanProvider = wlSecurityBeanProvider;
        this.wlSecurityInterceptStrategyProvider = wlSecurityInterceptStrategyProvider;
        this.wlSecureThreadFactoryProvider = wlSecureThreadFactoryProvider;
    }

    public boolean applicableTo(ElementProperties properties) {
        ChainElementType elementType = ChainElementType.fromString((String)((String)properties.getProperties().get("elementType")));
        return ChainElementType.JMS_SENDER.equals((Object)elementType) || ChainElementType.JMS_TRIGGER.equals((Object)elementType);
    }

    public void apply(SpringCamelContext context, ElementProperties elementProperties, DeploymentInfo deploymentInfo) {
        boolean secured;
        String elementId = elementProperties.getElementId();
        Map properties = elementProperties.getProperties();
        Properties environment = new Properties();
        String jmsInitialContextFactory = this.variablesService.injectVariables((String)properties.get("initialContextFactory"));
        String jmsProviderUrl = this.variablesService.injectVariables((String)properties.get("providerUrl"));
        String jmsConnectionFactoryName = this.variablesService.injectVariables((String)properties.get("connectionFactoryName"));
        String username = this.variablesService.injectVariables((String)properties.get("username"));
        String password = this.variablesService.injectVariables((String)properties.get("password"));
        environment.put("java.naming.factory.initial", jmsInitialContextFactory);
        environment.put("java.naming.provider.url", jmsProviderUrl);
        boolean bl = secured = !StringUtils.isBlank((CharSequence)username) && !StringUtils.isBlank((CharSequence)password);
        if (secured) {
            environment.put("java.naming.security.principal", username);
            environment.put("java.naming.security.credentials", password);
        }
        JndiTemplate jmsJndiTemplate = new JndiTemplate(environment);
        JndiObjectFactoryBean jmsConnectionFactory = new JndiObjectFactoryBean();
        jmsConnectionFactory.setJndiTemplate(jmsJndiTemplate);
        jmsConnectionFactory.setJndiName(jmsConnectionFactoryName);
        jmsConnectionFactory.setProxyInterface(ConnectionFactory.class);
        jmsConnectionFactory.setLookupOnStartup(false);
        jmsConnectionFactory.setExposeAccessContext(true);
        try {
            jmsConnectionFactory.afterPropertiesSet();
        }
        catch (NamingException exception) {
            throw new RuntimeException("Failed to create JMS connection factory", exception);
        }
        JndiDestinationResolver jndiDestinationResolver = new JndiDestinationResolver();
        jndiDestinationResolver.setJndiTemplate(jmsJndiTemplate);
        jndiDestinationResolver.setFallbackToDynamicDestination(true);
        JmsConfiguration jmsConfiguration = new JmsConfiguration();
        jmsConfiguration.setConnectionFactory((ConnectionFactory)jmsConnectionFactory.getObject());
        jmsConfiguration.setDestinationResolver((DestinationResolver)jndiDestinationResolver);
        WeblogicSecurityBean wlSecurityBean = (WeblogicSecurityBean)this.wlSecurityBeanProvider.getIfAvailable();
        WeblogicSecureThreadFactory wlSecureThreadFactory = (WeblogicSecureThreadFactory)this.wlSecureThreadFactoryProvider.getIfAvailable();
        WeblogicSecurityInterceptStrategy wlSecurityInterceptStrategy = (WeblogicSecurityInterceptStrategy)this.wlSecurityInterceptStrategyProvider.getIfAvailable();
        if (secured && wlSecurityBean != null && wlSecureThreadFactory != null && wlSecurityInterceptStrategy != null) {
            wlSecurityBean.setProviderUrl(jmsProviderUrl);
            wlSecurityBean.setSecurityPrincipal(username);
            wlSecurityBean.setSecurityCredentials(password);
            wlSecureThreadFactory.setName("jms-thread-factory-" + elementId);
            wlSecureThreadFactory.setWeblogicSecurityBean(wlSecurityBean);
            ThreadPoolProfile profile = context.getExecutorServiceManager().getDefaultThreadPoolProfile();
            ThreadPoolTaskExecutor jmsTaskExecutor = new ThreadPoolTaskExecutor();
            jmsTaskExecutor.setBeanName("jms-task-executor-" + elementId);
            jmsTaskExecutor.setThreadFactory((ThreadFactory)wlSecureThreadFactory);
            jmsTaskExecutor.setCorePoolSize(profile.getPoolSize().intValue());
            jmsTaskExecutor.setMaxPoolSize(profile.getMaxPoolSize().intValue());
            jmsTaskExecutor.setKeepAliveSeconds(profile.getKeepAliveTime().intValue());
            jmsTaskExecutor.setQueueCapacity(profile.getMaxQueueSize().intValue());
            jmsTaskExecutor.afterPropertiesSet();
            jmsConfiguration.setTaskExecutor((TaskExecutor)jmsTaskExecutor);
            wlSecurityInterceptStrategy.setTargetId(elementId);
            wlSecurityInterceptStrategy.setWeblogicSecurityBean(wlSecurityBean);
            context.getCamelContextExtension().addInterceptStrategy((InterceptStrategy)wlSecurityInterceptStrategy);
        }
        JmsComponent jmsComponent = new JmsComponent(jmsConfiguration);
        String componentName = this.buildJmsComponentName(elementId, properties);
        context.addComponent(componentName, (org.apache.camel.Component)jmsComponent);
    }

    private String buildJmsComponentName(String elementId, Map<String, String> properties) {
        return String.format("jms-%s", elementId);
    }
}

