/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.util;

import io.grpc.MethodDescriptor;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.component.grpc.GrpcUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class GrpcProcessorUtils {
    private GrpcProcessorUtils() {
    }

    public static Class<?> getRequestClass(Exchange exchange) throws NoSuchMethodException {
        Method method = GrpcProcessorUtils.getMainServiceMethod((Exchange)exchange);
        return method.getParameterTypes()[0];
    }

    public static Class<?> getResponseClass(Exchange exchange) throws NoSuchMethodException {
        Method method = GrpcProcessorUtils.getMainServiceMethod((Exchange)exchange);
        Type[] types = method.getGenericParameterTypes();
        ParameterizedType pType = (ParameterizedType)types[1];
        return (Class)pType.getActualTypeArguments()[0];
    }

    private static Method getMainServiceMethod(Exchange exchange) throws NoSuchMethodException {
        String fullServiceName = (String)exchange.getProperty("internalProperty_grpcServiceName", String.class);
        String methodName = (String)exchange.getProperty("internalProperty_grpcMethodName", String.class);
        String serviceName = GrpcUtils.extractServiceName((String)fullServiceName);
        String servicePackage = GrpcUtils.extractServicePackage((String)fullServiceName);
        String camelCaseMethodName = GrpcUtils.convertMethod2CamelCase((String)methodName);
        Class grpcServiceClass = GrpcUtils.constructGrpcImplBaseClass((String)servicePackage, (String)serviceName, (CamelContext)exchange.getContext());
        return Arrays.stream(grpcServiceClass.getMethods()).filter(m -> camelCaseMethodName.equals(m.getName())).findFirst().orElseThrow(() -> {
            String message = String.format("gRPC method not found: %s", MethodDescriptor.generateFullMethodName((String)fullServiceName, (String)methodName));
            return new NoSuchMethodException(message);
        });
    }
}

