/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.model;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.camel.spring.SpringCamelContext;
import org.qubership.integration.platform.engine.model.deployment.engine.EngineDeployment;
import org.qubership.integration.platform.engine.model.deployment.update.DeploymentUpdate;

public class RuntimeIntegrationCache {
    private final ConcurrentMap<String, Lock> chainLocks = new ConcurrentHashMap<String, Lock>();
    private final ConcurrentMap<String, SpringCamelContext> contexts = new ConcurrentHashMap<String, SpringCamelContext>();
    private final ConcurrentMap<String, EngineDeployment> deployments = new ConcurrentHashMap<String, EngineDeployment>();
    private final AtomicReference<Collection<DeploymentUpdate>> deploymentsToRetry = new AtomicReference(new LinkedList());

    public Lock getLockForChain(String chainId) {
        return this.chainLocks.computeIfAbsent(chainId, key -> new ReentrantLock(true));
    }

    public Collection<DeploymentUpdate> flushDeploymentsToRetry() {
        if (this.deploymentsToRetry.get().isEmpty()) {
            return Collections.emptyList();
        }
        return this.deploymentsToRetry.getAndSet(new LinkedList());
    }

    public void putToRetryQueue(DeploymentUpdate deployment) {
        this.deploymentsToRetry.updateAndGet(collection -> {
            collection.add(deployment);
            return collection;
        });
    }

    public void removeRetryDeploymentFromQueue(String deploymentId) {
        this.deploymentsToRetry.updateAndGet(collection -> {
            collection.removeIf(deployment -> deploymentId.equals(deployment.getDeploymentInfo().getDeploymentId()));
            return collection;
        });
    }

    public ConcurrentMap<String, SpringCamelContext> getContexts() {
        return this.contexts;
    }

    public ConcurrentMap<String, EngineDeployment> getDeployments() {
        return this.deployments;
    }
}

