/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.persistence.shared.repository;

import java.util.List;
import org.qubership.integration.platform.engine.persistence.shared.entity.Checkpoint;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;

public interface CheckpointRepository
extends JpaRepository<Checkpoint, String> {
    public Checkpoint findFirstBySessionIdAndSessionChainIdAndCheckpointElementId(String var1, String var2, String var3);

    public List<Checkpoint> findAllBySessionChainIdAndSessionId(String var1, String var2, Pageable var3);

    @Query(nativeQuery=true, value="    SELECT si.chain_id AS chain_id,\n           si.chain_name AS chain_name,\n           SUM( octet_length(chpt.id)\n               + octet_length(chpt.session_id)\n               + octet_length(chpt.checkpoint_element_id)\n               + octet_length(chpt.headers)\n               + 4                         --oid fixed size\n               + length(lo_get(chpt.body)) --actual body size from pg_large_objects\n               + 8                         --timestamp fixed size\n               + octet_length(chpt.context_data) ) AS raw_data_size\n    FROM engine.checkpoints chpt LEFT JOIN engine.sessions_info si ON chpt.session_id = si.id\n    GROUP BY si.chain_id, si.chain_name;\n")
    public List<Object[]> findAllChainCheckpointSize();
}

