/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.service.debugger.util.json;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.qubership.integration.platform.engine.service.debugger.util.json.DelegatingSerializerBase;

class CircularReferencesAwareSerializer
extends DelegatingSerializerBase {
    private final Set<Object> selfReferencedObjects;
    private final Map<Object, UUID> idMap;

    public CircularReferencesAwareSerializer(Set<Object> selfReferencedObjects) {
        this.selfReferencedObjects = selfReferencedObjects;
        this.idMap = new IdentityHashMap<Object, UUID>();
    }

    public void serialize(Object value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        if (this.selfReferencedObjects.contains(value)) {
            if (this.idMap.containsKey(value)) {
                gen.writeString(this.idMap.get(value).toString());
            } else {
                UUID identifier = UUID.randomUUID();
                this.idMap.put(value, identifier);
                gen.writeRaw("{\"@json-id\":\"" + identifier.toString() + "\",\"reference\":");
                this.getSerializer(value).serialize(value, gen, serializers);
                gen.writeRaw("}");
            }
        } else {
            this.getSerializer(value).serialize(value, gen, serializers);
        }
    }
}

