/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.camel.components.kafka;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.binder.kafka.KafkaClientMetrics;
import java.util.Collection;
import java.util.Properties;
import org.apache.camel.component.kafka.KafkaClientFactory;
import org.apache.camel.component.kafka.KafkaConfiguration;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.producer.Producer;

public class TaggedMetricsKafkaClientFactory
implements KafkaClientFactory {
    private final KafkaClientFactory delegate;
    private final MeterRegistry meterRegistry;
    private final Collection<Tag> tags;

    public TaggedMetricsKafkaClientFactory(KafkaClientFactory delegate, MeterRegistry meterRegistry, Collection<Tag> tags) {
        this.delegate = delegate;
        this.meterRegistry = meterRegistry;
        this.tags = tags;
    }

    public Producer getProducer(Properties kafkaProps) {
        Producer producer = this.delegate.getProducer(kafkaProps);
        new KafkaClientMetrics(producer, (Iterable)this.tags).bindTo(this.meterRegistry);
        return producer;
    }

    public Consumer getConsumer(Properties kafkaProps) {
        Consumer consumer = this.delegate.getConsumer(kafkaProps);
        new KafkaClientMetrics(consumer, (Iterable)this.tags).bindTo(this.meterRegistry);
        return consumer;
    }

    public String getBrokers(KafkaConfiguration configuration) {
        return this.delegate.getBrokers(configuration);
    }
}

