/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.opensearch.ism.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import java.time.Instant;
import java.util.List;
import org.qubership.integration.platform.engine.opensearch.ism.converters.LongToInstantConverter;
import org.qubership.integration.platform.engine.opensearch.ism.model.ErrorNotification;
import org.qubership.integration.platform.engine.opensearch.ism.model.ISMTemplate;
import org.qubership.integration.platform.engine.opensearch.ism.model.Policy;
import org.qubership.integration.platform.engine.opensearch.ism.model.State;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
public class Policy {
    private String policyId;
    private String description;
    private Long schemaVersion;
    @JsonDeserialize(converter=LongToInstantConverter.class)
    private Instant lastUpdatedTime;
    private ErrorNotification errorNotification;
    private String defaultState;
    private List<State> states;
    private List<ISMTemplate> ismTemplate;

    public static PolicyBuilder builder() {
        return new PolicyBuilder();
    }

    public PolicyBuilder toBuilder() {
        return new PolicyBuilder().policyId(this.policyId).description(this.description).schemaVersion(this.schemaVersion).lastUpdatedTime(this.lastUpdatedTime).errorNotification(this.errorNotification).defaultState(this.defaultState).states(this.states).ismTemplate(this.ismTemplate);
    }

    public String getPolicyId() {
        return this.policyId;
    }

    public String getDescription() {
        return this.description;
    }

    public Long getSchemaVersion() {
        return this.schemaVersion;
    }

    public Instant getLastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public ErrorNotification getErrorNotification() {
        return this.errorNotification;
    }

    public String getDefaultState() {
        return this.defaultState;
    }

    public List<State> getStates() {
        return this.states;
    }

    public List<ISMTemplate> getIsmTemplate() {
        return this.ismTemplate;
    }

    public void setPolicyId(String policyId) {
        this.policyId = policyId;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setSchemaVersion(Long schemaVersion) {
        this.schemaVersion = schemaVersion;
    }

    @JsonDeserialize(converter=LongToInstantConverter.class)
    public void setLastUpdatedTime(Instant lastUpdatedTime) {
        this.lastUpdatedTime = lastUpdatedTime;
    }

    public void setErrorNotification(ErrorNotification errorNotification) {
        this.errorNotification = errorNotification;
    }

    public void setDefaultState(String defaultState) {
        this.defaultState = defaultState;
    }

    public void setStates(List<State> states) {
        this.states = states;
    }

    public void setIsmTemplate(List<ISMTemplate> ismTemplate) {
        this.ismTemplate = ismTemplate;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Policy)) {
            return false;
        }
        Policy other = (Policy)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$schemaVersion = this.getSchemaVersion();
        Long other$schemaVersion = other.getSchemaVersion();
        if (this$schemaVersion == null ? other$schemaVersion != null : !((Object)this$schemaVersion).equals(other$schemaVersion)) {
            return false;
        }
        String this$policyId = this.getPolicyId();
        String other$policyId = other.getPolicyId();
        if (this$policyId == null ? other$policyId != null : !this$policyId.equals(other$policyId)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        Instant this$lastUpdatedTime = this.getLastUpdatedTime();
        Instant other$lastUpdatedTime = other.getLastUpdatedTime();
        if (this$lastUpdatedTime == null ? other$lastUpdatedTime != null : !((Object)this$lastUpdatedTime).equals(other$lastUpdatedTime)) {
            return false;
        }
        ErrorNotification this$errorNotification = this.getErrorNotification();
        ErrorNotification other$errorNotification = other.getErrorNotification();
        if (this$errorNotification == null ? other$errorNotification != null : !this$errorNotification.equals(other$errorNotification)) {
            return false;
        }
        String this$defaultState = this.getDefaultState();
        String other$defaultState = other.getDefaultState();
        if (this$defaultState == null ? other$defaultState != null : !this$defaultState.equals(other$defaultState)) {
            return false;
        }
        List this$states = this.getStates();
        List other$states = other.getStates();
        if (this$states == null ? other$states != null : !((Object)this$states).equals(other$states)) {
            return false;
        }
        List this$ismTemplate = this.getIsmTemplate();
        List other$ismTemplate = other.getIsmTemplate();
        return !(this$ismTemplate == null ? other$ismTemplate != null : !((Object)this$ismTemplate).equals(other$ismTemplate));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Policy;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $schemaVersion = this.getSchemaVersion();
        result = result * 59 + ($schemaVersion == null ? 43 : ((Object)$schemaVersion).hashCode());
        String $policyId = this.getPolicyId();
        result = result * 59 + ($policyId == null ? 43 : $policyId.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        Instant $lastUpdatedTime = this.getLastUpdatedTime();
        result = result * 59 + ($lastUpdatedTime == null ? 43 : ((Object)$lastUpdatedTime).hashCode());
        ErrorNotification $errorNotification = this.getErrorNotification();
        result = result * 59 + ($errorNotification == null ? 43 : $errorNotification.hashCode());
        String $defaultState = this.getDefaultState();
        result = result * 59 + ($defaultState == null ? 43 : $defaultState.hashCode());
        List $states = this.getStates();
        result = result * 59 + ($states == null ? 43 : ((Object)$states).hashCode());
        List $ismTemplate = this.getIsmTemplate();
        result = result * 59 + ($ismTemplate == null ? 43 : ((Object)$ismTemplate).hashCode());
        return result;
    }

    public String toString() {
        return "Policy(policyId=" + this.getPolicyId() + ", description=" + this.getDescription() + ", schemaVersion=" + this.getSchemaVersion() + ", lastUpdatedTime=" + String.valueOf(this.getLastUpdatedTime()) + ", errorNotification=" + String.valueOf(this.getErrorNotification()) + ", defaultState=" + this.getDefaultState() + ", states=" + String.valueOf(this.getStates()) + ", ismTemplate=" + String.valueOf(this.getIsmTemplate()) + ")";
    }

    public Policy() {
    }

    public Policy(String policyId, String description, Long schemaVersion, Instant lastUpdatedTime, ErrorNotification errorNotification, String defaultState, List<State> states, List<ISMTemplate> ismTemplate) {
        this.policyId = policyId;
        this.description = description;
        this.schemaVersion = schemaVersion;
        this.lastUpdatedTime = lastUpdatedTime;
        this.errorNotification = errorNotification;
        this.defaultState = defaultState;
        this.states = states;
        this.ismTemplate = ismTemplate;
    }
}

