/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.service.deployment.processing.actions.context.create;

import java.util.List;
import java.util.Map;
import org.apache.camel.spring.SpringCamelContext;
import org.qubership.integration.platform.engine.model.ChainElementType;
import org.qubership.integration.platform.engine.model.deployment.update.DeploymentConfiguration;
import org.qubership.integration.platform.engine.model.deployment.update.DeploymentInfo;
import org.qubership.integration.platform.engine.model.deployment.update.ElementProperties;
import org.qubership.integration.platform.engine.service.SdsService;
import org.qubership.integration.platform.engine.service.deployment.processing.DeploymentProcessingAction;
import org.qubership.integration.platform.engine.service.deployment.processing.qualifiers.OnAfterDeploymentContextCreated;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnBean(value={SdsService.class})
@OnAfterDeploymentContextCreated
public class SdsSchedulerJobsRegistrar
implements DeploymentProcessingAction {
    private final SdsService sdsService;

    @Autowired
    public SdsSchedulerJobsRegistrar(SdsService sdsService) {
        this.sdsService = sdsService;
    }

    public void execute(SpringCamelContext context, DeploymentInfo deploymentInfo, DeploymentConfiguration deploymentConfiguration) {
        List<Map> sdsElementsProperties = deploymentConfiguration.getProperties().stream().filter(SdsSchedulerJobsRegistrar::isSdsTrigger).map(ElementProperties::getProperties).toList();
        this.sdsService.registerSchedulerJobs(context, deploymentInfo, sdsElementsProperties);
    }

    private static boolean isSdsTrigger(ElementProperties elementProperties) {
        Map properties = elementProperties.getProperties();
        ChainElementType elementType = ChainElementType.fromString((String)((String)properties.get("elementType")));
        return ChainElementType.isSdsTriggerElement((ChainElementType)elementType);
    }
}

