/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.camel;

import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.github.resilience4j.circuitbreaker.CircuitBreakerConfig;
import io.github.resilience4j.circuitbreaker.event.CircuitBreakerEvent;
import io.github.resilience4j.core.EventConsumer;
import java.time.Duration;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.component.resilience4j.ResilienceProcessor;
import org.apache.camel.component.resilience4j.ResilienceReifier;
import org.apache.camel.model.CircuitBreakerDefinition;
import org.qubership.integration.platform.engine.model.logging.LogLoggingLevel;
import org.qubership.integration.platform.engine.service.debugger.CamelDebugger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomResilienceReifier
extends ResilienceReifier {
    private static final Logger log = LoggerFactory.getLogger(CustomResilienceReifier.class);

    public CustomResilienceReifier(Route route, CircuitBreakerDefinition definition) {
        super(route, definition);
    }

    public Processor createProcessor() throws Exception {
        ResilienceProcessor processor = (ResilienceProcessor)super.createProcessor();
        CircuitBreakerConfig config = this.getCircuitBreakerConfig(processor);
        CircuitBreaker circuitBreaker = CircuitBreaker.of((String)((CircuitBreakerDefinition)this.definition).getId(), (CircuitBreakerConfig)config);
        CircuitBreaker.EventPublisher eventPublisher = circuitBreaker.getEventPublisher();
        this.configureEventPublisher(eventPublisher, processor, circuitBreaker);
        processor.setCircuitBreaker(circuitBreaker);
        return processor;
    }

    private CircuitBreakerConfig getCircuitBreakerConfig(ResilienceProcessor processor) {
        return CircuitBreakerConfig.custom().automaticTransitionFromOpenToHalfOpenEnabled(processor.isCircuitBreakerTransitionFromOpenToHalfOpenEnabled()).failureRateThreshold(processor.getCircuitBreakerFailureRateThreshold()).minimumNumberOfCalls(processor.getCircuitBreakerMinimumNumberOfCalls()).permittedNumberOfCallsInHalfOpenState(processor.getCircuitBreakerPermittedNumberOfCallsInHalfOpenState()).slidingWindowSize(processor.getCircuitBreakerSlidingWindowSize()).slidingWindowType(CircuitBreakerConfig.SlidingWindowType.valueOf((String)processor.getCircuitBreakerSlidingWindowType())).slowCallDurationThreshold(Duration.ofSeconds(this.parseLong(((CircuitBreakerDefinition)this.definition).getResilience4jConfiguration().getSlowCallDurationThreshold()))).slowCallRateThreshold(processor.getCircuitBreakerSlowCallRateThreshold()).waitDurationInOpenState(Duration.ofSeconds(processor.getCircuitBreakerWaitDurationInOpenState())).writableStackTraceEnabled(processor.isCircuitBreakerWritableStackTraceEnabled()).build();
    }

    private void configureEventPublisher(CircuitBreaker.EventPublisher eventPublisher, ResilienceProcessor processor, CircuitBreaker circuitBreaker) {
        eventPublisher.onStateTransition(event -> {
            CircuitBreaker.StateTransition stateTransition = event.getStateTransition();
            CircuitBreaker.State fromState = stateTransition.getFromState();
            CircuitBreaker.State toState = stateTransition.getToState();
            LogLoggingLevel level = CustomResilienceReifier.getLoggingLevel(processor);
            if (CircuitBreaker.State.OPEN.equals((Object)toState)) {
                if (level.isWarnLevel()) {
                    log.warn("Circuit breaker changed state from {} to {}.", (Object)fromState, (Object)toState);
                }
            } else if (level.isInfoLevel()) {
                log.info("Circuit breaker changed state from {} to {}.", (Object)fromState, (Object)toState);
            }
        });
        eventPublisher.onSuccess(this.callIfLogLevel(processor, LogLoggingLevel::isInfoLevel, event -> log.info("Circuit breaker recorded a successful call. Elapsed time: {} ms.", (Object)event.getElapsedDuration().toMillis())));
        eventPublisher.onError(this.callIfLogLevel(processor, LogLoggingLevel::isInfoLevel, event -> log.info("Circuit breaker recorded an error: '{}'. Elapsed time: {} ms.", (Object)event.getThrowable(), (Object)event.getElapsedDuration().toMillis())));
        eventPublisher.onReset(this.callIfLogLevel(processor, LogLoggingLevel::isInfoLevel, event -> log.info("Circuit breaker reset")));
        eventPublisher.onIgnoredError(this.callIfLogLevel(processor, LogLoggingLevel::isInfoLevel, event -> log.info("Circuit breaker recorded an error which has been ignored: '{}'. Elapsed time: {} ms.", (Object)event.getThrowable(), (Object)event.getElapsedDuration().toMillis())));
        eventPublisher.onCallNotPermitted(this.callIfLogLevel(processor, LogLoggingLevel::isInfoLevel, event -> log.info("Circuit breaker recorded a call which was not permitted. Circuit breaker state is {}.", (Object)circuitBreaker.getState())));
        eventPublisher.onFailureRateExceeded(this.callIfLogLevel(processor, LogLoggingLevel::isWarnLevel, event -> log.warn("Circuit breaker exceeded failure rate threshold. Current failure rate: {}.", (Object)Float.valueOf(event.getFailureRate()))));
        eventPublisher.onSlowCallRateExceeded(this.callIfLogLevel(processor, LogLoggingLevel::isWarnLevel, event -> log.warn("Circuit breaker exceeded slow call rate threshold. Current slow call rate: {}.", (Object)Float.valueOf(event.getSlowCallRate()))));
    }

    private <T extends CircuitBreakerEvent> EventConsumer<T> callIfLogLevel(ResilienceProcessor processor, Predicate<LogLoggingLevel> levelPredicate, Consumer<T> consumer) {
        return event -> {
            LogLoggingLevel level = CustomResilienceReifier.getLoggingLevel(processor);
            if (levelPredicate.test(level)) {
                consumer.accept(event);
            }
        };
    }

    private static LogLoggingLevel getLoggingLevel(ResilienceProcessor processor) {
        return Optional.ofNullable(processor.getCamelContext().getDebugger()).map(CamelDebugger.class::cast).map(CamelDebugger::getRelatedProperties).map(properties -> properties.getActualRuntimeProperties().getLogLoggingLevel()).orElse(LogLoggingLevel.WARN);
    }
}

