/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.mapper.atlasmap.functions;

import io.atlasmap.core.BaseFunctionFactory;
import io.atlasmap.expression.Expression;
import io.atlasmap.expression.parser.ParseException;
import io.atlasmap.v2.AtlasModelFactory;
import java.util.List;
import java.util.Objects;

public class ReplaceAllFunctionFactory
extends BaseFunctionFactory {
    public String getName() {
        return "replaceAll";
    }

    public Expression create(List<Expression> args) throws ParseException {
        if (args.size() != 3) {
            String message = String.format("%s expects 3 argument.", this.getName());
            throw new ParseException(message);
        }
        Expression stringExpression = args.get(0);
        Expression regexExpression = args.get(1);
        Expression replacementExpression = args.get(2);
        return ctx -> {
            Object value = stringExpression.evaluate(ctx).getValue();
            Object regex = regexExpression.evaluate(ctx).getValue();
            Object replacement = replacementExpression.evaluate(ctx).getValue();
            return AtlasModelFactory.wrapWithField(Objects.isNull(value) || Objects.isNull(regex) || Objects.isNull(replacement) ? null : value.toString().replaceAll(regex.toString(), replacement.toString()));
        };
    }
}

