/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.rest.v1.controller;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.qubership.integration.platform.engine.rest.v1.dto.checkpoint.CheckpointSessionDTO;
import org.qubership.integration.platform.engine.rest.v1.mapper.SessionInfoMapper;
import org.qubership.integration.platform.engine.service.CheckpointSessionService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/engine/sessions"}, produces={"application/json"})
@Tag(name="session-controller", description="Session Controller")
public class SessionController {
    private static final Logger log = LoggerFactory.getLogger(SessionController.class);
    private final CheckpointSessionService checkpointSessionService;
    private final SessionInfoMapper sessionInfoMapper;

    @Autowired
    public SessionController(CheckpointSessionService checkpointSessionService, SessionInfoMapper sessionInfoMapper) {
        this.checkpointSessionService = checkpointSessionService;
        this.sessionInfoMapper = sessionInfoMapper;
    }

    @GetMapping
    @Transactional(value="checkpointTransactionManager")
    @Operation(description="List all sessions with available checkpoints by their ids")
    public ResponseEntity<List<CheckpointSessionDTO>> findSessions(@RequestParam(required=false) @Parameter(description="List of the session ids separated by comma") List<String> ids) {
        return ResponseEntity.ok(this.checkpointSessionService.findSessions(Optional.ofNullable(ids).orElse(Collections.emptyList())).stream().map(this.sessionInfoMapper::asDTO).toList());
    }
}

